% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html.R
\name{as_html.spork}
\alias{as_html.spork}
\title{Convert Spork to Html}
\usage{
\method{as_html}{spork}(x, ...)
}
\arguments{
\item{x}{spork}

\item{...}{passed to \code{\link{as_html.spar}}}
}
\value{
html
}
\description{
Converts spork to html.
Vectorized version of \code{\link{as_html.spar}}.
}
\examples{
x <- c(
  'V_c./F',
  'AUC_ss',
  'C_max_ss',
  'var^eta_j'
)
x <- as_spork(x)
as_html(x)
as_html(as_spork('gravitational force (kg\\\\.m/s^2.)'))
}
\seealso{
Other html: 
\code{\link{[.html}()},
\code{\link{[[.html}()},
\code{\link{as_html.greek}()},
\code{\link{as_html.spar}()},
\code{\link{as_html}()},
\code{\link{html2xml}()},
\code{\link{htmlToken}()}

Other spork: 
\code{\link{[.spork}()},
\code{\link{[[.spork}()},
\code{\link{as.list.spork}()},
\code{\link{as.png.spork}()},
\code{\link{as_latex.spork}()},
\code{\link{as_plotmath.spork}()},
\code{\link{as_previews.spork}()},
\code{\link{as_spar.default}()},
\code{\link{as_spar.spork}()},
\code{\link{as_spork.character}()},
\code{\link{as_spork.factor}()},
\code{\link{as_spork.spork}()},
\code{\link{as_spork}()},
\code{\link{ggplot.spork}()},
\code{\link{greek}()}

Other interface: 
\code{\link{as.expression.plotmath}()},
\code{\link{as_html.spar}()},
\code{\link{as_latex.spar}()},
\code{\link{as_latex.spork}()},
\code{\link{as_plotmath.spar}()},
\code{\link{as_plotmath.spork}()},
\code{\link{as_previews.spork}()},
\code{\link{as_spork.character}()},
\code{\link{htmlToken}()},
\code{\link{latexToken}()},
\code{\link{plotmathToken}()}
}
\concept{html}
\concept{interface}
\concept{spork}
