% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spork-to-latex.R
\name{spork_to_latex}
\alias{spork_to_latex}
\title{Convert One Spork to Latex}
\usage{
spork_to_latex(
  x,
  unrecognized = getOption("latex_unrecognized", "latexToken"),
  italics = FALSE,
  math = TRUE,
  ...
)
}
\arguments{
\item{x}{character}

\item{unrecognized}{function to process unrecognized tokens: default \code{\link{latexToken}}}

\item{italics}{whether to use italics or not (default: no)}

\item{math}{whether to wrap in math environment (default: yes)}

\item{...}{passed arguments}
}
\value{
character
}
\description{
Converts one spork to latex.
See description for \code{\link{as_spork}}.
By default, unrecognized tokens are returned
literally.  However, Greek symbols and latex
metacharacters are escaped.
See \code{\link{latexToken}}.
}
\examples{
library(magrittr)
'V_c./F' \%>\% spork_to_latex
'AUC_ss' \%>\% spork_to_latex
'C_max_ss' \%>\% spork_to_latex
'var^eta_j' \%>\% spork_to_latex
'& \% $ # \\\\_ { } ~ \\\\^ \\\\' \%>\% spork_to_latex
'one joule (Omega) ~ 1 kg*m^2./s^2' \%>\% spork_to_latex
}
\seealso{
Other latex: 
\code{\link{as_latex.spork}()},
\code{\link{as_latex}()},
\code{\link{latexToken}()}
}
\concept{latex}
\keyword{internal}
