% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.position.r
\docType{methods}
\name{graph.map.plot.position}
\alias{graph.map.plot.position}
\alias{graph.map.plot.position,SpatialNetwork-method}
\alias{graph.map.plot.position,SpatialPolygons-method}
\title{Plot a map labelled with the ID numbering}
\usage{
graph.map.plot.position(x, label = "", ...)

\S4method{graph.map.plot.position}{SpatialPolygons}(x, label = "", ...)

\S4method{graph.map.plot.position}{SpatialNetwork}(x, label = "", ...)
}
\arguments{
\item{x}{an object for which a \code{graph.map.plot.position} method is defined.}

\item{label}{a character of length 1 for prefixing seat numbering.}

\item{...}{other arguments to pass to the plot function. The main usage is setting the \code{cex} value.}
}
\description{
The \code{graph.map.plot.position} function allows to plot maps defined as for example \code{SpatialNetwork} or \code{SpatialPolygons} objects, and render the ID numbering.
}
\section{Methods (by class)}{
\itemize{
\item \code{SpatialPolygons}: method for \code{SpatialPolygons} objects.

\item \code{SpatialNetwork}: method for \code{SpatialNetwork} objects.
}}
\examples{
## The world map
data(world.map.simplified, package = "spnet")

graph.map.plot.position(world.map.simplified)
graph.map.plot.position(world.map.simplified, cex = 0.4)
graph.map.plot.position(world.map.simplified, label = 'ID ', cex = 0.3)
}
\seealso{
Other res: \code{\link{SpatialNetwork-class}}
}

