% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ds_aat}
\alias{ds_aat}
\title{Example Approach Avoidance Task (AAT) Measurement Data in JASMIN2 Format}
\format{
An object of class \code{data.frame} with 6528 rows and 12 columns.
}
\usage{
ds_aat
}
\description{
The JASMIN1 AAT was an irrelevant feature task, in which participants were instructed to
approach/avoid left/right rotated stimuli. This particular AAT was administered (and described in detail) in 
\href{https://doi.org/10.1111/add.14071}{Boffo et al., 2018}. Participants were presented stimuli from a "test"
category, which were gambling-related pictures, and from a "control" category, which were pictures unrelated
to gambling. It registered approach responses by participants pressing (and holding) the arrow down key,
while avoid responses were given via the arrow up key. Upon a response, the stimulus zoomed in or
out, until it disappeared from the screen. The first response to a stimulus was logged. 
The dataset contains one row per trial.
This dataset was graciously provided by \href{https://www.researchgate.net/profile/Eva_Schmitz4}{Eva Schmitz}.
}
\details{
Overview of columns:
\itemize{
  \item UserID. Identifies participants
  \item approach_tilt. If "left", participants were instructed to approach left rotated stimuli. If "right", participants were instructed to approach right rotated stimuli.
  \item block_type. Type of block: "practice" for practice trials with neutral stimuli, "assess" for assessment trials with salient stimuli
  \item block. Counts blocks, starting at zero
  \item trial. Counts trials in blocks, starting at zero
  \item appr. If "yes", this trial was an approach trial. If "no", this trial was an avoid trial.
  \item tilt. Whether the stimulus was rotated to the "left" or to the "right"
  \item cat. Stimulus category: "practice", "test", or "control"
  \item stim. Stimulus ID
  \item response. Response; 1 = correct, 2 = incorrect, 3 = timeout (no response in 4000 ms), 4 = invalid key
  \item rt. Response time in milliseconds
  \item sust. Was approach or avoid response sustained until the stimulus was completely zoomed in or out?
}
}
\keyword{datasets}
