% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iSpline.R
\name{iSpline}
\alias{iSpline}
\title{I-Spline Basis for Polynomial Splines}
\usage{
iSpline(x, df = NULL, knots = NULL, degree = 3, intercept = FALSE,
        Boundary.knots = range(x), ...)
}
\arguments{
\item{x}{The predictor variable.  Missing values are allowed and will be
returned as they were.}

\item{df}{Degrees of freedom.  One can specify \code{df} rather than
\code{knots}, then the function chooses "df - degree"
(minus one if there is an intercept) knots at suitable quantiles of \code{x}
(which will ignore missing values).  The default, \code{NULL}, corresponds
to no inner knots, i.e., "degree - intercept".}

\item{knots}{The internal breakpoints that define the spline.  The
default is \code{NULL}, which results in a basis for ordinary
polynomial regression.  Typical values are the mean or median
for one knot, quantiles for more knots.  See also
\code{Boundary.knots}.}

\item{degree}{Non-negative integer degree of the piecewise polynomial. The
default value is 3 for cubic splines. Note that the degree of I-spline is
defined to be the degree of the associated M-spline instead of actual
polynomial degree. In other words, I-spline basis of degree 2 is defined as
the integral of associated M-spline basis of degree 2.}

\item{intercept}{If \code{TRUE}, an intercept is included in the basis;
Default is \code{FALSE}.}

\item{Boundary.knots}{Boundary points at which to anchor the I-spline basis.
By default, they are the range of the non-\code{NA} data.  If both
\code{knots} and \code{Boundary.knots} are supplied, the basis parameters
do not depend on \code{x}. Data can extend beyond \code{Boundary.knots}.}

\item{...}{Optional arguments for future usage.}
}
\value{
A matrix of dimension \code{length(x)} by
\code{df = degree + length(knots)} (plus on if intercept is included).
Attributes that correspond to the arguments specified are returned
for usage for \code{\link{predict.iSpline}}. The corresponding M-spline
basis matrix is also returned in attribute named \code{msMat}.
}
\description{
This function generates the I-spline (integral of M-spline) basis matrix
for a polynomial spline.
}
\details{
It is an implementation of the close form I-spline basis based on the
recursion formula of B-spline basis.  Internally, it calls
\code{\link{mSpline}} and \code{\link{bSpline}}, and generates a basis
matrix for representing the family of piecewise polynomials and their
corresponding integrals with the specified interior knots and degree,
evaluated at the values of \code{x}.
}
\examples{
## Example given in the reference paper by Ramsay (1988)
library(graphics)
x <- seq(0, 1, by = .01)
knots <- c(0.3, 0.5, 0.6)
iMat <- iSpline(x, knots = knots, degree = 2, intercept = TRUE)
matplot(x, iMat, type = "l", ylab = "I-spline basis")
abline(v = knots, lty = 2, col = "gray")
}
\references{
Ramsay, J. O. (1988). Monotone regression splines in action.
\emph{Statistical science}, 3(4), 425--441.
}
\seealso{
\code{\link{predict.iSpline}} for evaluation at given (new) values;
\code{\link{mSpline}} for M-spline basis;
\code{\link{cSpline}} for C-spline basis;
\code{\link{bSpline}} for B-spline basis;
\code{\link{ibs}} for integral of B-spline basis.
}

