% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ggproto_visualize.r
\name{proto_origin}
\alias{proto_origin}
\alias{proto_origin2d}
\alias{proto_origin1d}
\title{Tour proto for data origin zero mark}
\usage{
proto_origin(
  identity_args = list(color = "grey60", size = 0.5, alpha = 0.9),
  tail_size = 0.05
)

proto_origin1d(identity_args = list(color = "grey60", size = 0.5, alpha = 0.9))
}
\arguments{
\item{identity_args}{A list of static, identity arguments passed into
the primary geom. For instance,
\code{geom_point(size = 2, alpha = .7)} becomes
\code{identity_args = list(size = 2, alpha = .7)}.
Also passes more foundational arguments such as stat and position, though
these have been tested less.}

\item{tail_size}{How long the origin mark should extended
relative to the observations. Defaults to .05, 5\% of the projection space.}
}
\description{
Adds a zero mark showing the location of the origin for the central data area.
}
\examples{
library(spinifex)
dat  <- scale_sd(penguins_na.rm[, 1:4])
clas <- penguins_na.rm$species

## 2D case:
gt_path <- save_history(dat, grand_tour(), max_bases = 5)
ggt <- ggtour(gt_path, dat, angle = .1) +
  proto_point(list(color = clas, shape = clas)) +
  proto_origin() ## `+` in center
\donttest{
animate_plotly(ggt)
}

## 1D case:
gt_path1d <- save_history(dat, grand_tour(d = 1), max_bases = 5)

ggt <- ggtour(gt_path1d, dat) +
  proto_density(list(fill = clas, color = clas)) +
  proto_origin1d() ## Adds line at 0.
\donttest{
animate_plotly(ggt)
}
}
\seealso{
Other ggtour proto functions: 
\code{\link{append_fixed_y}()},
\code{\link{facet_wrap_tour}()},
\code{\link{ggtour}()},
\code{\link{proto_basis}()},
\code{\link{proto_default}()},
\code{\link{proto_density}()},
\code{\link{proto_density2d}()},
\code{\link{proto_hex}()},
\code{\link{proto_highlight}()},
\code{\link{proto_hline0}()},
\code{\link{proto_point}()},
\code{\link{proto_text}()}
}
\concept{ggtour proto functions}
