% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{distance_to_sp}
\alias{distance_to_sp}
\title{Collecting distances between input planes and input special plane.}
\usage{
distance_to_sp(planes, special_plane)
}
\arguments{
\item{planes}{Input planes (e.g. result of guided tour)}

\item{special_plane}{Plane defining the optimal view}
}
\value{
numeric vector containing all distances
}
\description{
If the optimal view is known, we can use the distance between a given plane
and the optimal one as a proxy to diagnose the performance of the guided tour.
}
\examples{
planes <- purrr::rerun(10, tourr::basis_random(5))
special_plane <- basis_matrix(1,2,5)
d <- distance_to_sp(planes, special_plane)
plot(d)
}
