% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjusted.actuals.R
\name{adjusted.actuals}
\alias{adjusted.actuals}
\title{Adjusted actual values}
\usage{
adjusted.actuals(data, coord, plot.maps = FALSE, color.maps = FALSE)
}
\arguments{
\item{data}{a dataframe or matrix containing actual presence/absence (binary,
0 or 1) values in 1st column and predicted values (numeric between 0 and 1)
in 2nd column.}

\item{coord}{a matrix of two columns of the same length providing integer,
consecutively numbered coordinates for each occurence and prediction in
\code{data}.}

\item{plot.maps}{A logical indicating whether maps should be plotted.
Default is FALSE.}

\item{color.maps}{A logical value. If \code{TRUE}, produces colorful maps.
If \code{FALSE}, produces grayscale maps. Default is grayscale.}
}
\value{
A vector of adjusted actual values.
}
\description{
Adjusts actual presence/absence data based on the autocorrelation
in the predictions of a model. The function will optionally plot results of
model predictions, un-modified actual presence/absence, and adjusted  values.
}
\examples{
data(hook)
data<- hook[,1:2]
coord<- hook[,3:4]
aa<-adjusted.actuals(data,coord,plot.maps=TRUE)

}
\author{
Gudrun Carl
}
