% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvi_plot.R
\name{rvi.plot}
\alias{rvi.plot}
\title{Relative Variable Importance}
\usage{
rvi.plot(formula, family, data, coord, maxlevel, detail = TRUE,
  wavelet = "haar", wtrafo = "dwt", n.eff = NULL)
}
\arguments{
\item{formula}{A model formula}

\item{family}{\code{gaussian}, \code{binomial}, and \code{poisson}
are supported.}

\item{data}{A data frame or set of vectors of equal length.}

\item{coord}{X,Y coordinates for each observation. Coordinates should be
consecutive integers.}

\item{maxlevel}{An integer for maximum scale level}

\item{detail}{Remove smooth wavelets? If \code{TRUE}, only detail components are analyzed.
If set to \code{FALSE}, smooth and detail components are analyzed. Default is \code{TRUE}.}

\item{wavelet}{Type of wavelet: \code{haar}, \code{d4}, or \code{la8}}

\item{wtrafo}{Type of wavelet transform: \code{dwt} or \code{modwt}}

\item{n.eff}{A numeric value of effective sample size}
}
\value{
A matrix containing the relative importance of each variable
in the regression at each value of the scale level.
}
\description{
Creates model selection tables, calculates and plots relative
variable importance based on the scale level of a given model.
}
\details{
Calculates the relative importance of each variable
using multi-model inference methods in a wavelet multi-resolution regression
framework implemented in \code{mmiWMRR}. The scale level dependent
results are then graphically displayed.
}
\examples{
data(carlinadata)
coords<- carlinadata[,4:5]

\dontrun{

wrm<- WRM(carlina.horrida ~ aridity + land.use,"poisson",
              carlinadata,coords,level=1,wavelet="d4")

mmi<- mmiWMRR(wrm,data=carlinadata,scale=3,detail=T)



# Plot scale-dependent relative variable importance
rvi.plot(carlina.horrida ~ aridity + land.use,"poisson",
         carlinadata,coords,maxlevel=4,detail=TRUE,wavelet="d4")
}
}
