% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delaunay.R
\name{plotDelaunayOnSphere}
\alias{plotDelaunayOnSphere}
\title{Plot spherical Delaunay triangulation}
\usage{
plotDelaunayOnSphere(
  del,
  colors = "random",
  distinctArgs = list(seedcolors = c("#ff0000", "#00ff00", "#0000ff")),
  randomArgs = list(hue = "random", luminosity = "bright"),
  edges = FALSE,
  vertices = FALSE,
  ecolor = "black",
  lwd = 3,
  vcolor = "black",
  vradius = NA,
  ...
)
}
\arguments{
\item{del}{an output of \code{\link{DelaunayOnSphere}}}

\item{colors}{controls the filling colors of the triangles, either
\code{NA} for no color, or a single color, or \code{"random"} to get
multiple colors with \code{\link[colorsGen]{randomColor}}, or
\code{"distinct"} to get multiple colors with
\code{\link[Polychrome]{createPalette}}}

\item{distinctArgs}{if \code{colors = "distinct"}, a list of arguments
passed to \code{\link[Polychrome]{createPalette}}}

\item{randomArgs}{if \code{colors = "random"}, a list of arguments passed
to \code{\link[colorsGen]{randomColor}}}

\item{edges}{Boolean, whether to plot the edges}

\item{vertices}{Boolean, whether to plot the vertices}

\item{ecolor}{a color for the edges}

\item{lwd}{line width for the edges, if they are plotted}

\item{vcolor}{a color for the vertices}

\item{vradius}{a radius for the vertices, which are plotted as spheres (if
they are plotted); \code{NA} for a default value}

\item{...}{arguments passed to \code{\link[rgl]{shade3d}} to plot the
spherical triangles}
}
\value{
No value is returned.
}
\description{
Plot a spherical Delaunay triangulation.
}
\examples{
library(sphereTessellation)
library(rgl)

vertices <- t(cuboctahedron3d()$vb[-4L, ])
del <- DelaunayOnSphere(vertices, radius = sqrt(2))

open3d(windowRect = 50 + c(0, 0, 512, 512), zoom = 0.8)
plotDelaunayOnSphere(del)
}
