% Copyright (C) 2005 Roger S. Bivand
%
\name{gmeta6}
\alias{gmeta6}
\alias{getLocationProj}
\alias{gmeta2grd}
\alias{print.gmeta6}
\alias{get.ignore.stderrOption}
\alias{get.stop_on_no_flags_parasOption}
\alias{get.useGDALOption}
\alias{get.pluginOption}
\alias{get.echoCmdOption}
\alias{set.ignore.stderrOption}
\alias{set.stop_on_no_flags_parasOption}
\alias{set.useGDALOption}
\alias{set.pluginOption}
\alias{set.echoCmdOption}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Reads GRASS metadata from the current LOCATION}
\description{
  GRASS LOCATION metadata are read into a list in R; helper function getLocationProj returns an spproj-compliant PROJ.4 string of projection information. The helper function \code{gmeta2grd} creates a GridTopology object from the current GRASS mapset region definitions.
}
\usage{
gmeta6(ignore.stderr = FALSE)
getLocationProj(ignore.stderr = FALSE)
gmeta2grd(ignore.stderr = FALSE)
\method{print}{gmeta6}(x, ...)
get.ignore.stderrOption()
get.stop_on_no_flags_parasOption()
get.useGDALOption()
get.pluginOption()
get.echoCmdOption()
set.ignore.stderrOption(value)
set.stop_on_no_flags_parasOption(value)
set.useGDALOption(value)
set.pluginOption(value)
set.echoCmdOption(value)
}
\arguments{
  \item{ignore.stderr}{default FALSE, can be set to TRUE to silence \code{system()} output to standard error; does not apply on Windows platforms}
  \item{x}{S3 object returned by gmeta6}
  \item{...}{arguments passed through print method}
  \item{value}{logical value for setting options on \code{ignore.stderr} set by default on package load to FALSE, \code{stop_on_no_flags_paras} set by default on package load to TRUE, \code{useGDAL} set by default on package load to TRUE, \code{plugin} set by default on package load to NULL, \code{echoCmd} set by default on package load to FALSE}
}
%- maybe also 'usage' for other objects documented here.

\value{
  Returns list of g.gisenv, g.region -g3, and g.proj values
}

\author{Roger S. Bivand, e-mail: \email{Roger.Bivand@nhh.no.}}

\examples{
if (nchar(Sys.getenv("GISRC")) > 0) {
  G <- gmeta6()
  print(G)
  CRS(getLocationProj())
  grd <- gmeta2grd()
  print(grd)
  ncells <- prod(slot(grd, "cells.dim"))
  df <- data.frame(k=rep(1, ncells))
  mask_SG <- SpatialGridDataFrame(grd, data=df)
  print(summary(mask_SG))
}
}
\keyword{spatial}

