% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spftir.R
\name{spint}
\alias{spint}
\title{Interpolation for Intermediate Values of a Matrix of Mid-infrared Spectra}
\usage{
spint(spectra, n = 1)
}
\arguments{
\item{spectra}{matrix. The matrix of FTIR spectra. The first row corresponds to wavenumber; the remaining rows corresponds to absorbances.}

\item{n}{numeric. Number of interpolated values between two variables. Defaults to 1.}
}
\value{
A matrix spectra with interpolated values. The first row corresponds to wavenumber; the remaining rows corresponds to absorbances.
}
\description{
Allow the interpolation of intermediate values of a matrix of mid-infrared spectra.
}
\examples{
data(spData)
# Convert data frame to matrix
spectra <- as.matrix(t(spData))
# Interpolated spectra
int <- spint(spectra=spectra, n=1)
}
\author{
Claudio Pozo Valenzuela [aut, cre] and Saddys Rodriguez-llamazares [aut]
}

