% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_sp-network-pair.R
\docType{class}
\name{sp_network_pair-class}
\alias{sp_network_pair-class}
\alias{dat,sp_network_pair-method}
\alias{dat<-,sp_network_pair-method}
\alias{id,sp_network_pair-method}
\alias{id<-,sp_network_pair-method}
\alias{npairs,sp_network_pair-method}
\alias{nnodes,sp_network_pair-method}
\title{Class sp_network_pair}
\usage{
\S4method{dat}{sp_network_pair}(object)

\S4method{dat}{sp_network_pair}(object) <- value

\S4method{id}{sp_network_pair}(object)

\S4method{id}{sp_network_pair}(object) <- value

\S4method{npairs}{sp_network_pair}(object)

\S4method{nnodes}{sp_network_pair}(object)
}
\arguments{
\item{object}{A sp_network_pair-class}

\item{value}{An object to replace the existing id/data}
}
\description{
An S4 class which holds information on origin-destination (OD) pairs.
Each OD pair is composed of two nodes (see \code{\link[=sp_network_nodes-class]{sp_network_nodes-class()}}).
All origins belong to the same (origin-) network and all destination belong
to the same (destination-) network. It is possible to choose the same
network for origins and destinations, which enables to represent OD pairs
within the same network.
}
\section{Slots}{

\describe{
\item{\code{orig_net_id}}{A character that serves as identifier for the origin network}

\item{\code{orig_nnodes}}{A numeric that represents the number of nodes in the origin network}

\item{\code{dest_net_id}}{A character that serves as identifier for the destination network}

\item{\code{dest_nnodes}}{A numeric that represents the number of nodes in the destination network}

\item{\code{network_pair_id}}{A character identifying the pair of networks}

\item{\code{pair_data}}{A data.frame containing information on origin-destination pairs}

\item{\code{npairs}}{A numeric indicating the number of origin-destination pairs}
}}

\examples{
## access the data describing the node pairs

net_pair_ge_ge <- pull_member(multi_net_usa_ge,"ge_ge")
dat(net_pair_ge_ge)

## access the id of a network pair

net_pair_ge_ge <- pull_member(multi_net_usa_ge,"ge_ge")
id(net_pair_ge_ge)
id(net_pair_ge_ge) <- "Germany_Germany"

## access the number of node pairs in a network pair

net_pair_ge_ge <- pull_member(multi_net_usa_ge,"ge_ge")
npairs(net_pair_ge_ge)

## access the number of origin and destination nodes in a network pair
net_pair_ge_ge <- pull_member(multi_net_usa_ge,"ge_ge")
nnodes(net_pair_ge_ge)
nnodes(net_pair_ge_ge)["orig"]
nnodes(net_pair_ge_ge)["dest"]
prod(nnodes(net_pair_ge_ge) == npairs(net_pair_ge_ge))

}
\seealso{
Other spflow network classes: 
\code{\link{sp_multi_network-class}},
\code{\link{sp_network_nodes-class}},
\code{\link{spflow_network_classes}}
}
\concept{spflow network classes}
