% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diags.R
\name{get_filenames}
\alias{get_filenames}
\title{Get the filenames of the SPEW output, separated by the level}
\usage{
get_filenames(output_dir, summary_level = 2, agent_type = "household",
  pop_type = "US")
}
\arguments{
\item{output_dir}{path to top level directory of SPEW folders.  Ex. "./10" for Delaware}

\item{summary_level}{For the US, 1-state, 2-county, 3-tract.  For IPUMS, 1 -country, 2-province.  For "custom," these are defined by the user's input data.}

\item{agent_type}{either "household" or "people"}

\item{pop_type}{"US" for a US population, "IPUMS" for IPUMS population, or "custom" for a custom population.  This effects what the summary levels represent}
}
\value{
list of lists where the first list is a list of the different filenames for each summary level and the second list contains a dataframe of the different file paths along with the name of the larger, aggregated region
}
\description{
Get the filenames of the SPEW output, separated by the level
}
