/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.security.SecureContainer;
import bibliothek.gui.dock.station.flap.FlapDropInfo;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;

public class ButtonPane
extends SecureContainer {
    private FlapDockStation station;
    private FlapDropInfo dropInfo;
    private boolean resetStarted = false;
    private Content content = new Content();

    public ButtonPane(FlapDockStation station) {
        this.setBasePane(this.content);
        this.station = station;
    }

    public void setBackground(BackgroundAlgorithm background) {
        this.content.setBackground(background);
    }

    public void setDropInfo(FlapDropInfo dropInfo) {
        this.dropInfo = dropInfo;
        this.repaint();
    }

    public boolean titleContains(int x, int y) {
        if (this.getComponentCount() == 0) {
            int h;
            int w = this.getWidth() / 3;
            return this.contains(x - w, y - (h = this.getHeight() / 3)) && this.contains(x + w, y + h);
        }
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = this.getComponent(i);
            if (!c.contains(x - c.getX(), y - c.getY())) continue;
            return true;
        }
        return false;
    }

    public void resetTitles() {
        if (!this.resetStarted) {
            Runnable code = new Runnable(){

                public void run() {
                    ButtonPane.this.resetStarted = false;
                    ButtonPane.this.getContentPane().removeAll();
                    int n = ButtonPane.this.station.getDockableCount();
                    for (int i = 0; i < n; ++i) {
                        DockTitle title = ButtonPane.this.station.getButton(i);
                        if (title == null) continue;
                        ButtonPane.this.getContentPane().add(title.getComponent());
                    }
                    ButtonPane.this.revalidate();
                }
            };
            this.resetStarted = true;
            if (EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(code);
            } else {
                code.run();
            }
        }
    }

    protected void paintOverlay(Graphics g) {
        if (this.dropInfo != null && this.dropInfo.isDraw() && this.dropInfo.getCombineTarget() == null) {
            int y2;
            int x2;
            int y1;
            int x1;
            boolean horizontal;
            int left = this.dropInfo.getIndex() - 1;
            int right = left + 1;
            DockTitle leftTitle = left < 0 ? null : this.station.getButton(left);
            DockTitle rightTitle = right >= this.station.getDockableCount() ? null : this.station.getButton(right);
            boolean bl = horizontal = this.station.getDirection() == FlapDockStation.Direction.SOUTH || this.station.getDirection() == FlapDockStation.Direction.NORTH;
            if (leftTitle == null && rightTitle == null) {
                if (horizontal) {
                    x1 = this.getX() + this.getWidth() / 2;
                    y1 = 0;
                    x2 = x1;
                    y2 = this.getHeight();
                } else {
                    x1 = 0;
                    y1 = this.getY() + this.getHeight() / 2;
                    x2 = this.getWidth();
                    y2 = y1;
                }
            } else if (leftTitle == null) {
                if (horizontal) {
                    x1 = rightTitle.getComponent().getX();
                    y1 = 0;
                    x2 = x1;
                    y2 = this.getHeight();
                } else {
                    x1 = 0;
                    y1 = rightTitle.getComponent().getY();
                    x2 = this.getWidth();
                    y2 = y1;
                }
            } else if (rightTitle == null) {
                if (horizontal) {
                    x1 = leftTitle.getComponent().getX() + leftTitle.getComponent().getWidth();
                    y1 = 0;
                    x2 = x1;
                    y2 = this.getHeight();
                } else {
                    x1 = 0;
                    y1 = leftTitle.getComponent().getY() + leftTitle.getComponent().getHeight();
                    x2 = this.getWidth();
                    y2 = y1;
                }
            } else if (horizontal) {
                x1 = (rightTitle.getComponent().getX() + leftTitle.getComponent().getX() + leftTitle.getComponent().getWidth()) / 2;
                y1 = 0;
                x2 = x1;
                y2 = this.getHeight();
            } else {
                x1 = 0;
                y1 = (rightTitle.getComponent().getY() + leftTitle.getComponent().getY() + leftTitle.getComponent().getHeight()) / 2;
                x2 = this.getWidth();
                y2 = y1;
            }
            this.station.getPaint().drawInsertionLine(g, x1, y1, x2, y2);
        }
    }

    public int indexAt(int x, int y) {
        if (this.station.getDirection() == FlapDockStation.Direction.SOUTH || this.station.getDirection() == FlapDockStation.Direction.NORTH) {
            int n = this.station.getDockableCount();
            for (int i = 0; i < n; ++i) {
                DockTitle title = this.station.getButton(i);
                if (title == null) continue;
                int tx = title.getComponent().getX();
                int tw = title.getComponent().getWidth();
                if (x <= tx) {
                    return i;
                }
                if (x > tx + tw) continue;
                if (x < tx + tw / 2) {
                    return i;
                }
                return i + 1;
            }
        } else {
            int n = this.station.getDockableCount();
            for (int i = 0; i < n; ++i) {
                DockTitle title = this.station.getButton(i);
                if (title == null) continue;
                int ty = title.getComponent().getY();
                int th = title.getComponent().getHeight();
                if (y <= ty) {
                    return i;
                }
                if (y > ty + th) continue;
                if (y < ty + th / 2) {
                    return i;
                }
                return i + 1;
            }
        }
        return this.station.getDockableCount();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        int i;
        int width = 0;
        int height = 0;
        if (this.station.getDirection() == FlapDockStation.Direction.NORTH || this.station.getDirection() == FlapDockStation.Direction.SOUTH) {
            int n = this.station.getDockableCount();
            for (i = 0; i < n; ++i) {
                DockTitle title = this.station.getButton(i);
                if (title == null) continue;
                Dimension size = title.getComponent().getPreferredSize();
                width += size.width;
                height = Math.max(height, size.height);
            }
        } else {
            int n = this.station.getDockableCount();
            for (i = 0; i < n; ++i) {
                DockTitle title = this.station.getButton(i);
                if (title == null) continue;
                Dimension size = title.getComponent().getPreferredSize();
                height += size.height;
                width = Math.max(width, size.width);
            }
        }
        Dimension empty = this.station.getMinimumSize();
        return new Dimension(Math.max(empty.width, width), Math.max(empty.height, height));
    }

    private class Content
    extends BackgroundPanel {
        public Content() {
            super(null, true, false);
        }

        public void doLayout() {
            Insets insets = this.getInsets();
            int x = insets.left;
            int y = insets.top;
            int width = this.getWidth() - insets.left - insets.right;
            int height = this.getHeight() - insets.top - insets.bottom;
            if (ButtonPane.this.station.getDirection() == FlapDockStation.Direction.NORTH || ButtonPane.this.station.getDirection() == FlapDockStation.Direction.SOUTH) {
                int i;
                int count = this.getComponentCount();
                int[] widths = new int[count];
                int preferredHeight = 0;
                int sum = 0;
                for (i = 0; i < count; ++i) {
                    Dimension size = this.getComponent(i).getPreferredSize();
                    widths[i] = size.width;
                    preferredHeight = Math.max(preferredHeight, size.height);
                    sum += widths[i];
                }
                if (ButtonPane.this.station.isSmallButtons() && preferredHeight < height) {
                    int delta = height - preferredHeight;
                    y += delta / 2;
                    height = preferredHeight;
                }
                if (sum > width) {
                    double ratio = (double)width / (double)sum;
                    for (int i2 = 0; i2 < count; ++i2) {
                        int temp = (int)((double)widths[i2] * ratio);
                        this.getComponent(i2).setBounds(x, y, temp, height);
                        x += temp;
                    }
                } else {
                    for (i = 0; i < count; ++i) {
                        this.getComponent(i).setBounds(x, y, widths[i], height);
                        x += widths[i];
                    }
                }
            } else {
                int i;
                int count = this.getComponentCount();
                int[] heights = new int[count];
                int preferredWidth = 0;
                int sum = 0;
                for (i = 0; i < count; ++i) {
                    Dimension size = this.getComponent(i).getPreferredSize();
                    heights[i] = size.height;
                    preferredWidth = Math.max(preferredWidth, size.width);
                    sum += heights[i];
                }
                if (ButtonPane.this.station.isSmallButtons() && preferredWidth < width) {
                    int delta = width - preferredWidth;
                    x += delta / 2;
                    width = preferredWidth;
                }
                if (sum > height) {
                    double ratio = (double)height / (double)sum;
                    for (int i3 = 0; i3 < count; ++i3) {
                        int temp = (int)((double)heights[i3] * ratio);
                        this.getComponent(i3).setBounds(x, y, width, temp);
                        y += temp;
                    }
                } else {
                    for (i = 0; i < count; ++i) {
                        this.getComponent(i).setBounds(x, y, width, heights[i]);
                        y += heights[i];
                    }
                }
            }
            this.repaint();
        }
    }
}

