/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode;

import bibliothek.gui.dock.facile.mode.ExternalizedMode;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.MinimizedMode;
import bibliothek.gui.dock.facile.mode.NormalMode;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.DockablePropertyFactory;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.gui.dock.station.flap.FlapDockProperty;
import bibliothek.gui.dock.station.screen.ScreenDockProperty;
import bibliothek.gui.dock.support.mode.ModeSettingsConverter;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationSettingConverter
implements ModeSettingsConverter<Location, Location> {
    private PropertyTransformer transformer = new PropertyTransformer();

    public void addFactory(DockablePropertyFactory factory) {
        this.transformer.addFactory(factory);
    }

    @Override
    public Location convertToSetting(Location a) {
        return a;
    }

    @Override
    public Location convertToWorld(Location b) {
        return b;
    }

    @Override
    public void writeProperty(Location element, DataOutputStream out) throws IOException {
        Version.write(out, Version.VERSION_1_0_8);
        out.writeUTF(element.getMode().toString());
        out.writeUTF(element.getRoot());
        this.transformer.write(element.getLocation(), out);
    }

    @Override
    public Location readProperty(DataInputStream in) throws IOException {
        Version version = Version.read(in);
        version.checkCurrent();
        boolean version8 = Version.VERSION_1_0_8.compareTo(version) <= 0;
        Path mode = null;
        if (version8) {
            mode = new Path(in.readUTF());
        }
        String root = in.readUTF();
        DockableProperty location = this.transformer.read(in);
        if (!version8) {
            mode = this.guessMode(location);
        }
        return new Location(mode, root, location);
    }

    private Path guessMode(DockableProperty location) {
        if (location instanceof FlapDockProperty) {
            return MinimizedMode.IDENTIFIER;
        }
        if (location instanceof ScreenDockProperty) {
            return ExternalizedMode.IDENTIFIER;
        }
        return NormalMode.IDENTIFIER;
    }

    @Override
    public void writePropertyXML(Location b, XElement element) {
        element.addElement("mode").setString(b.getMode().toString());
        element.addElement("root").setString(b.getRoot());
        this.transformer.writeXML(b.getLocation(), element.addElement("location"));
    }

    @Override
    public Location readPropertyXML(XElement element) {
        XElement xmode = element.getElement("mode");
        Path mode = null;
        if (xmode != null) {
            mode = new Path(xmode.getString());
        }
        String root = element.getElement("root").getString();
        DockableProperty location = this.transformer.readXML(element.getElement("location"));
        if (mode == null) {
            mode = this.guessMode(location);
        }
        return new Location(mode, root, location);
    }
}

