/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PriorityValue;
import bibliothek.gui.dock.util.UIBridge;
import bibliothek.gui.dock.util.UIValue;
import bibliothek.util.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIProperties<V, U extends UIValue<V>, B extends UIBridge<V, U>> {
    private Map<Path, PriorityValue<B>> bridges = new HashMap<Path, PriorityValue<B>>();
    private Map<String, PriorityValue<V>> resources = new HashMap<String, PriorityValue<V>>();
    private List<Observer> observers = new LinkedList<Observer>();
    private int updateLock = 0;
    private DockController controller;

    public UIProperties(DockController dockController) {
        this.controller = dockController;
    }

    public DockController getController() {
        return this.controller;
    }

    public void lockUpdate() {
        ++this.updateLock;
    }

    public void unlockUpdate() {
        --this.updateLock;
        if (this.updateLock == 0) {
            for (Observer observer : this.observers) {
                observer.resetAll();
            }
        }
    }

    public void publish(Priority priority, Path path, B b) {
        if (priority == null) {
            throw new IllegalArgumentException("priority must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        if (b == null) {
            throw new IllegalArgumentException("bridge must not be null");
        }
        PriorityValue<Object> priorityValue = this.bridges.get(path);
        if (priorityValue == null) {
            priorityValue = new PriorityValue();
            this.bridges.put(path, priorityValue);
        }
        if (priorityValue.set(priority, b) && this.updateLock == 0) {
            for (Observer observer : this.observers) {
                observer.resetBridge();
            }
        }
    }

    public void unpublish(Priority priority, Path path) {
        PriorityValue<B> priorityValue = this.bridges.get(path);
        if (priorityValue != null) {
            boolean bl = priorityValue.set(priority, null);
            if (priorityValue.get() == null) {
                this.bridges.remove(path);
            }
            if (bl && this.updateLock == 0) {
                for (Observer observer : this.observers) {
                    observer.resetBridge();
                }
            }
        }
    }

    public void unpublish(Priority priority, B b) {
        Iterator<PriorityValue<B>> iterator = this.bridges.values().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            PriorityValue<B> priorityValue = iterator.next();
            if (priorityValue.get(priority) != b) continue;
            boolean bl2 = bl = priorityValue.set(priority, null) || bl;
            if (priorityValue.get() != null) continue;
            iterator.remove();
        }
        if (bl && this.updateLock == 0) {
            for (Observer observer : this.observers) {
                observer.resetBridge();
            }
        }
    }

    public void add(String string, Path path, U u) {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (u == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        Observer observer = new Observer(this, string, path, u);
        this.observers.add(observer);
    }

    public void remove(U u) {
        ListIterator<Observer> listIterator = this.observers.listIterator();
        while (listIterator.hasNext()) {
            Observer observer = listIterator.next();
            if (observer.getValue() != u) continue;
            listIterator.remove();
            observer.setBridge(null, false);
            return;
        }
    }

    protected B getBridgeFor(Path path) {
        while (path != null) {
            UIBridge uIBridge;
            PriorityValue<B> priorityValue = this.bridges.get(path);
            if (priorityValue != null && (uIBridge = (UIBridge)priorityValue.get()) != null) {
                return (B)uIBridge;
            }
            path = path.getParent();
        }
        return null;
    }

    public void put(Priority priority, String string, V v) {
        PriorityValue<Object> priorityValue = this.resources.get(string);
        if (priorityValue == null) {
            priorityValue = new PriorityValue();
            this.resources.put(string, priorityValue);
        }
        if (priorityValue.set(priority, v) && this.updateLock == 0) {
            for (Observer observer : this.observers) {
                if (!observer.id.equals(string)) continue;
                observer.update(v);
            }
        }
        if (priorityValue.get() == null) {
            this.resources.remove(string);
        }
    }

    public V get(String string) {
        PriorityValue<V> priorityValue = this.resources.get(string);
        return priorityValue == null ? null : (V)priorityValue.get();
    }

    public void clear(Priority priority) {
        Object object;
        Iterator<PriorityValue<V>> iterator = this.resources.values().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            ((PriorityValue)object).set(priority, null);
            if (((PriorityValue)object).get() != null) continue;
            iterator.remove();
        }
        object = this.bridges.values().iterator();
        while (object.hasNext()) {
            PriorityValue priorityValue = (PriorityValue)object.next();
            priorityValue.set(priority, null);
            if (priorityValue.get() != null) continue;
            object.remove();
        }
        if (this.updateLock == 0) {
            for (Observer observer : this.observers) {
                observer.resetAll();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Observer {
        private String id;
        private Path path;
        private U value;
        private B bridge;
        final /* synthetic */ UIProperties this$0;

        public Observer(String string, Path path, U u) {
            this.this$0 = var1_1;
            this.id = string;
            this.path = path;
            this.value = u;
            this.resetAll();
        }

        public U getValue() {
            return this.value;
        }

        public void resetAll() {
            Object b = this.this$0.getBridgeFor(this.path);
            if (b == null) {
                this.update(this.this$0.get(this.id));
            } else {
                this.setBridge(b, true);
            }
        }

        public void resetBridge() {
            this.setBridge(this.this$0.getBridgeFor(this.path), false);
        }

        public void setBridge(B b, boolean bl) {
            if (this.bridge != b) {
                if (this.bridge != null) {
                    this.bridge.remove(this.id, this.value);
                }
                this.bridge = b;
                if (this.bridge != null) {
                    this.bridge.add(this.id, this.value);
                }
                this.update(this.this$0.get(this.id));
            } else if (bl) {
                this.update(this.this$0.get(this.id));
            }
        }

        public void update(V v) {
            if (this.bridge == null) {
                this.value.set(v);
            } else {
                this.bridge.set(this.id, v, this.value);
            }
        }
    }
}

