/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;

public interface AWTComponentCaptureStrategy {
    public static final AWTComponentCaptureStrategy SCREEN_CAPTURE_STRATEGY = new AWTComponentCaptureStrategy(){

        public BufferedImage createCapture(DockController dockController, Component component) {
            try {
                if (!component.isShowing()) {
                    return null;
                }
                GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
                if (graphicsConfiguration == null) {
                    return null;
                }
                GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
                if (graphicsDevice == null) {
                    return null;
                }
                Robot robot = new Robot(graphicsDevice);
                Point point = new Point(0, 0);
                SwingUtilities.convertPointToScreen(point, component);
                return robot.createScreenCapture(new Rectangle(point, component.getSize()));
            }
            catch (AWTException aWTException) {
                aWTException.printStackTrace();
                return null;
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
    };
    public static final AWTComponentCaptureStrategy RECURSIVE_PAINT_STRATEGY = new AWTComponentCaptureStrategy(){

        public BufferedImage createCapture(DockController dockController, Component component) {
            BufferedImage bufferedImage = new BufferedImage(component.getWidth(), component.getHeight(), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            this.forcePaint(component, graphics2D);
            graphics2D.dispose();
            return bufferedImage;
        }

        private void forcePaint(Component component, Graphics graphics) {
            component.paintAll(graphics);
            if (component instanceof Container) {
                Container container = (Container)component;
                int n = container.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component component2 = container.getComponent(i);
                    int n2 = component2.getWidth();
                    int n3 = component2.getHeight();
                    if (n2 <= 0 || n3 <= 0) continue;
                    Graphics graphics2 = graphics.create(component2.getX(), component2.getY(), n2, n3);
                    this.forcePaint(component2, graphics2);
                    graphics2.dispose();
                }
            }
        }
    };
    public static final AWTComponentCaptureStrategy PAINT_ALL_STRATEGY = new AWTComponentCaptureStrategy(){

        public BufferedImage createCapture(DockController dockController, Component component) {
            BufferedImage bufferedImage = new BufferedImage(component.getWidth(), component.getHeight(), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            component.paintAll(graphics2D);
            graphics2D.dispose();
            return bufferedImage;
        }
    };
    public static final PropertyKey<AWTComponentCaptureStrategy> STRATEGY = new PropertyKey<AWTComponentCaptureStrategy>("dock.AWTComponentCaptureStrategy", new ConstantPropertyFactory<AWTComponentCaptureStrategy>(PAINT_ALL_STRATEGY), true);

    public BufferedImage createCapture(DockController var1, Component var2);
}

