/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.title;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;

public abstract class DockTitleRequest {
    private Dockable target;
    private DockStation parent;
    private DockTitleVersion version;
    private DockTitle title;
    private boolean answered = false;
    private boolean installed = false;
    private boolean requesting = false;

    public DockTitleRequest(DockStation dockStation, Dockable dockable, DockTitleVersion dockTitleVersion) {
        if (dockable == null) {
            throw new IllegalArgumentException("target must not be null");
        }
        if (dockTitleVersion == null) {
            throw new IllegalArgumentException("version must not be null");
        }
        this.target = dockable;
        this.parent = dockStation;
        this.version = dockTitleVersion;
    }

    public void install() {
        if (!this.installed) {
            this.installed = true;
            this.version.install(this);
        }
    }

    public void uninstall() {
        if (this.installed) {
            this.installed = false;
            this.version.uninstall(this);
        }
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public Dockable getTarget() {
        return this.target;
    }

    public DockStation getParent() {
        return this.parent;
    }

    public DockTitleVersion getVersion() {
        return this.version;
    }

    protected abstract void answer(DockTitle var1, DockTitle var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request() {
        this.answered = false;
        DockTitle dockTitle = this.title;
        try {
            this.requesting = true;
            this.executeRequestList();
        }
        finally {
            this.requesting = false;
        }
        if (dockTitle != this.title) {
            this.answer(dockTitle, this.title);
        }
    }

    protected boolean isAnswered() {
        return this.answered;
    }

    protected void executeRequestList() {
        this.requestDockTitle(this);
        if (this.answered) {
            return;
        }
        this.target.requestDockTitle(this);
        if (this.answered) {
            return;
        }
        if (this.parent != null) {
            this.parent.requestChildDockTitle(this);
            if (this.answered) {
                return;
            }
        }
        this.version.request(this);
    }

    public void requestDockTitle(DockTitleRequest dockTitleRequest) {
    }

    public void requestNull() {
        if (this.title != null) {
            DockTitle dockTitle = this.title;
            this.title = null;
            this.answer(dockTitle, this.title);
        }
    }

    public void answer(DockTitle dockTitle) {
        if (!this.requesting) {
            throw new IllegalStateException("not requesting a title");
        }
        this.answered = true;
        this.title = dockTitle;
    }

    public DockTitle getAnswer() {
        return this.title;
    }
}

