/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.buttons;

import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModelAdapter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiniButton<M extends BasicButtonModel>
extends JComponent {
    private Border normalBorder;
    private Border mouseOverBorder;
    private Border mousePressedBorder;
    private Border normalSelectedBorder;
    private Border mouseOverSelectedBorder;
    private Border mousePressedSelectedBorder;
    private M model;
    private BasicButtonModelAdapter listener = new BasicButtonModelAdapter(){

        public void mouseInside(BasicButtonModel basicButtonModel, boolean bl) {
            MiniButton.this.updateBorder();
        }

        public void mousePressed(BasicButtonModel basicButtonModel, boolean bl) {
            if (bl) {
                MiniButton.this.requestFocusInWindow();
            }
            MiniButton.this.updateBorder();
        }

        public void enabledStateChanged(BasicButtonModel basicButtonModel, boolean bl) {
            MiniButton.this.updateBorder();
        }

        public void selectedStateChanged(BasicButtonModel basicButtonModel, boolean bl) {
            MiniButton.this.updateBorder();
        }
    };

    public MiniButton(M m) {
        this.model = m;
        this.mousePressedBorder = BorderFactory.createBevelBorder(1);
        this.mouseOverBorder = BorderFactory.createBevelBorder(0);
        this.normalSelectedBorder = this.mousePressedBorder;
        this.mouseOverSelectedBorder = this.mousePressedBorder;
        this.mousePressedSelectedBorder = this.mouseOverBorder;
        this.setFocusable(true);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                MiniButton.this.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                MiniButton.this.repaint();
            }
        });
    }

    protected void setModel(M m) {
        if (this.model != null) {
            ((BasicButtonModel)this.model).removeListener(this.listener);
        }
        this.model = m;
        if (this.model != null) {
            ((BasicButtonModel)this.model).addListener(this.listener);
        }
        this.updateBorder();
    }

    public M getModel() {
        return this.model;
    }

    public Border getMouseOverBorder() {
        return this.mouseOverBorder;
    }

    public void setMouseOverBorder(Border border) {
        this.mouseOverBorder = border;
        this.updateBorder();
    }

    public Border getMousePressedBorder() {
        return this.mousePressedBorder;
    }

    public void setMousePressedBorder(Border border) {
        this.mousePressedBorder = border;
        this.updateBorder();
    }

    public Border getNormalBorder() {
        return this.normalBorder;
    }

    public void setNormalBorder(Border border) {
        this.normalBorder = border;
        this.updateBorder();
    }

    public Border getNormalSelectedBorder() {
        return this.normalSelectedBorder;
    }

    public void setNormalSelectedBorder(Border border) {
        this.normalSelectedBorder = border;
        this.updateBorder();
    }

    public Border getMouseOverSelectedBorder() {
        return this.mouseOverSelectedBorder;
    }

    public void setMouseOverSelectedBorder(Border border) {
        this.mouseOverSelectedBorder = border;
        this.updateBorder();
    }

    public Border getMousePressedSelectedBorder() {
        return this.mousePressedSelectedBorder;
    }

    public void setMousePressedSelectedBorder(Border border) {
        this.mousePressedSelectedBorder = border;
        this.updateBorder();
    }

    @Override
    public void paint(Graphics graphics) {
        Icon icon;
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
        }
        if ((icon = ((BasicButtonModel)this.model).getPaintIcon()) != null) {
            this.paintIcon(icon, graphics);
        }
        if (this.isFocusOwner() && this.isFocusable() && this.isEnabled()) {
            this.paintFocus(graphics);
        }
    }

    protected void paintIcon(Icon icon, Graphics graphics) {
        Insets insets = this.getMaxBorderInsets();
        icon.paintIcon(this, graphics, insets.left + (this.getWidth() - insets.left - insets.right - icon.getIconWidth()) / 2, insets.top + (this.getHeight() - insets.top - insets.bottom - icon.getIconHeight()) / 2);
    }

    protected void paintFocus(Graphics graphics) {
        graphics.setColor(this.getForeground());
        Insets insets = this.getMaxBorderInsets();
        int n = insets.left;
        int n2 = insets.right;
        int n3 = this.getWidth() - insets.left - insets.right;
        int n4 = this.getHeight() - insets.top - insets.bottom;
        --n4;
        graphics.drawLine(n, n2, n + 2, n2);
        graphics.drawLine(n, n2 + 1, n + 1, n2 + 1);
        graphics.drawLine(n, n2 + 2, n, n2 + 2);
        graphics.drawLine(n + --n3, n2, n + n3 - 2, n2);
        graphics.drawLine(n + n3, n2 + 1, n + n3 - 1, n2 + 1);
        graphics.drawLine(n + n3, n2 + 2, n + n3, n2 + 2);
        graphics.drawLine(n + n3, n2 + n4, n + n3 - 2, n2 + n4);
        graphics.drawLine(n + n3, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3, n2 + n4 - 2, n + n3, n2 + n4 - 2);
        graphics.drawLine(n, n2 + n4, n + 2, n2 + n4);
        graphics.drawLine(n, n2 + n4 - 1, n + 1, n2 + n4 - 1);
        graphics.drawLine(n, n2 + n4 - 2, n, n2 + n4 - 2);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Insets insets = this.getMaxBorderInsets();
        Dimension dimension = ((BasicButtonModel)this.model).getMaxIconSize();
        dimension.width = Math.max(dimension.width, 16);
        dimension.height = Math.max(dimension.height, 16);
        dimension.width += insets.left + insets.right + 2;
        dimension.height += insets.top + insets.bottom + 2;
        return dimension;
    }

    protected Insets getMaxBorderInsets() {
        Insets insets = new Insets(0, 0, 0, 0);
        for (int i = 0; i < 6; ++i) {
            Border border = null;
            switch (i) {
                case 0: {
                    border = this.getNormalBorder();
                    break;
                }
                case 1: {
                    border = this.getMouseOverBorder();
                    break;
                }
                case 2: {
                    border = this.getMousePressedBorder();
                    break;
                }
                case 3: {
                    border = this.getNormalSelectedBorder();
                    break;
                }
                case 4: {
                    border = this.getMouseOverSelectedBorder();
                    break;
                }
                case 5: {
                    border = this.getMousePressedSelectedBorder();
                }
            }
            if (border == null) continue;
            Insets insets2 = border.getBorderInsets(this);
            insets.left = Math.max(insets.left, insets2.left);
            insets.right = Math.max(insets.right, insets2.right);
            insets.top = Math.max(insets.top, insets2.top);
            insets.bottom = Math.max(insets.bottom, insets2.bottom);
        }
        return insets;
    }

    protected void updateBorder() {
        if (((BasicButtonModel)this.model).isEnabled() && ((BasicButtonModel)this.model).isMousePressed()) {
            if (((BasicButtonModel)this.model).isSelected()) {
                this.setBorder(this.getMousePressedSelectedBorder());
            } else {
                this.setBorder(this.getMousePressedBorder());
            }
        } else if (((BasicButtonModel)this.model).isEnabled() && ((BasicButtonModel)this.model).isMouseInside()) {
            if (((BasicButtonModel)this.model).isSelected()) {
                this.setBorder(this.getMouseOverSelectedBorder());
            } else {
                this.setBorder(this.getMouseOverBorder());
            }
        } else if (((BasicButtonModel)this.model).isSelected()) {
            this.setBorder(this.getNormalSelectedBorder());
        } else {
            this.setBorder(this.getNormalBorder());
        }
    }
}

