/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.menu;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.CombinedHandler;
import bibliothek.gui.dock.station.stack.CombinedMenu;
import bibliothek.gui.dock.station.stack.menu.CombinedMenuContent;
import bibliothek.gui.dock.station.stack.menu.CombinedMenuContentListener;
import bibliothek.gui.dock.station.stack.tab.AbstractTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCombinedMenu
extends AbstractTabPaneComponent
implements CombinedMenu {
    private Component component;
    private PropertyValue<CombinedMenuContent> content = new PropertyValue<CombinedMenuContent>(CombinedMenuContent.MENU_CONTENT){

        @Override
        protected void valueChanged(CombinedMenuContent combinedMenuContent, CombinedMenuContent combinedMenuContent2) {
        }
    };
    private List<Entry> entries = new ArrayList<Entry>();
    private DockController controller;
    private CombinedHandler<? super AbstractCombinedMenu> handler;

    public AbstractCombinedMenu(TabPane tabPane, CombinedHandler<? super AbstractCombinedMenu> combinedHandler) {
        super(tabPane);
        this.handler = combinedHandler;
    }

    protected void ensureComponent() {
        if (this.component == null) {
            this.component = this.createComponent();
        }
    }

    protected abstract Component createComponent();

    public void open() {
        Handler handler = new Handler();
        handler.open();
    }

    protected void closed() {
    }

    @Override
    public void setController(DockController dockController) {
        this.controller = dockController;
        this.content.setProperties(dockController);
    }

    public DockController getController() {
        return this.controller;
    }

    @Override
    public void setPaneVisible(boolean bl) {
        this.handler.setVisible(this, bl);
    }

    @Override
    public boolean isPaneVisible() {
        return this.handler.isVisible(this);
    }

    @Override
    public void setZOrder(int n) {
        this.handler.setZOrder(this, n);
    }

    @Override
    public int getZOrder() {
        return this.handler.getZOrder(this);
    }

    protected abstract void selected(Dockable var1);

    @Override
    public Component getComponent() {
        this.ensureComponent();
        return this.component;
    }

    @Override
    public void setIcon(int n, Icon icon) {
        this.entries.get((int)n).icon = icon;
    }

    @Override
    public void setText(int n, String string) {
        this.entries.get((int)n).text = string;
    }

    @Override
    public void setTooltip(int n, String string) {
        this.entries.get((int)n).tooltip = string;
    }

    @Override
    public void insert(int n, Dockable dockable) {
        Entry entry = new Entry();
        entry.dockable = dockable;
        entry.icon = dockable.getTitleIcon();
        entry.text = dockable.getTitleText();
        entry.tooltip = dockable.getTitleToolTip();
        this.entries.add(n, entry);
    }

    @Override
    public void remove(Dockable dockable) {
        int n = this.entries.size();
        for (int i = 0; i < n; ++i) {
            if (this.entries.get((int)i).dockable != dockable) continue;
            this.entries.remove(i);
            return;
        }
    }

    @Override
    public Dockable[] getDockables() {
        Dockable[] dockableArray = new Dockable[this.entries.size()];
        for (int i = 0; i < dockableArray.length; ++i) {
            dockableArray[i] = this.entries.get((int)i).dockable;
        }
        return dockableArray;
    }

    @Override
    public int getDockableCount() {
        return this.entries.size();
    }

    @Override
    public Dockable getDockable(int n) {
        return this.entries.get((int)n).dockable;
    }

    private class Entry {
        public Dockable dockable;
        public String text;
        public String tooltip;
        public Icon icon;

        private Entry() {
        }

        public CombinedMenuContent.Item toItem() {
            return new CombinedMenuContent.Item(this.dockable, this.text, this.tooltip, this.icon);
        }
    }

    private class Handler
    implements CombinedMenuContentListener {
        private CombinedMenuContent menu;

        public Handler() {
            this.menu = (CombinedMenuContent)AbstractCombinedMenu.this.content.getValue();
        }

        public void open() {
            if (this.menu == null) {
                return;
            }
            Component component = AbstractCombinedMenu.this.getComponent();
            CombinedMenuContent.Item[] itemArray = new CombinedMenuContent.Item[AbstractCombinedMenu.this.entries.size()];
            for (int i = 0; i < itemArray.length; ++i) {
                itemArray[i] = ((Entry)AbstractCombinedMenu.this.entries.get(i)).toItem();
            }
            this.menu.addCombinedMenuContentListener(this);
            this.menu.open(AbstractCombinedMenu.this.controller, component, 0, component.getHeight(), itemArray);
        }

        public void opened(CombinedMenuContent combinedMenuContent) {
        }

        public void canceled(CombinedMenuContent combinedMenuContent) {
            combinedMenuContent.removeCombinedMenuContentListener(this);
        }

        public void selected(CombinedMenuContent combinedMenuContent, Dockable dockable) {
            combinedMenuContent.removeCombinedMenuContentListener(this);
            AbstractCombinedMenu.this.selected(dockable);
        }
    }
}

