/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.split.SplitDockTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitDockGrid {
    private List<Node> nodes = new ArrayList<Node>();
    private List<Line> lines = new ArrayList<Line>();

    public SplitDockGrid() {
    }

    public SplitDockGrid(String string, Map<Character, Dockable[]> map) {
        String[] stringArray = string.split("\n");
        HashSet<Character> hashSet = new HashSet<Character>();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(Character.valueOf(string.charAt(i)));
        }
        for (Character c : hashSet) {
            Dockable[] dockableArray = map.get(c);
            if (dockableArray == null) continue;
            int n2 = Integer.MAX_VALUE;
            int n3 = Integer.MAX_VALUE;
            int n4 = Integer.MIN_VALUE;
            int n5 = Integer.MIN_VALUE;
            for (int i = 0; i < stringArray.length; ++i) {
                int n6 = stringArray[i].length();
                for (int j = 0; j < n6; ++j) {
                    if (stringArray[i].charAt(j) != c.charValue()) continue;
                    n2 = Math.min(n2, j);
                    n4 = Math.max(n4, j);
                    n3 = Math.min(n3, i);
                    n5 = Math.max(n5, i);
                }
            }
            this.addDockable(n2, n3, n4 - n2, n5 - n3, dockableArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addDockable(double d, double d2, double d3, double d4, Dockable ... dockableArray) {
        void var10_11;
        void var10_9;
        if (dockableArray == null) {
            throw new IllegalArgumentException("Dockable must not be null");
        }
        if (dockableArray.length == 0) {
            throw new IllegalArgumentException("Dockables must at least have one element");
        }
        for (Dockable dockable : dockableArray) {
            if (dockable != null) continue;
            throw new IllegalArgumentException("Entry of dockables-array is null");
        }
        if (d3 < 0.0) {
            throw new IllegalArgumentException("width < 0");
        }
        if (d4 < 0.0) {
            throw new IllegalArgumentException("height < 0");
        }
        Object var10_7 = null;
        int n = 0;
        for (Node node : this.nodes) {
            if (node.x != d || node.y != d2 || node.width != d3 || node.height != d4) continue;
            Node node2 = node;
            Dockable[] dockableArray2 = node2.dockables;
            n = dockableArray2.length;
            node2.dockables = new Dockable[dockableArray2.length + dockableArray.length];
            System.arraycopy(dockableArray2, 0, node2.dockables, 0, dockableArray2.length);
            break;
        }
        if (var10_9 == null) {
            Node node = new Node();
            node.x = d;
            node.y = d2;
            node.width = d3;
            node.height = d4;
            node.dockables = new Dockable[dockableArray.length];
            this.nodes.add(node);
        }
        System.arraycopy(dockableArray, 0, var10_11.dockables, n, dockableArray.length);
    }

    public void setSelected(double d, double d2, double d3, double d4, Dockable dockable) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable is null");
        }
        if (d3 < 0.0) {
            throw new IllegalArgumentException("width < 0");
        }
        if (d4 < 0.0) {
            throw new IllegalArgumentException("height < 0");
        }
        for (Node node : this.nodes) {
            if (node.x != d || node.y != d2 || node.width != d3 || node.height != d4) continue;
            for (Dockable dockable2 : node.dockables) {
                if (dockable2 != dockable) continue;
                node.selected = dockable;
                return;
            }
            throw new IllegalArgumentException("dockable is not in the described stack");
        }
        throw new IllegalArgumentException("there are no dockables registered with the given coordinates");
    }

    public void addVerticalDivider(double d, double d2, double d3) {
        Line line = new Line();
        line.horizontal = false;
        line.alpha = d;
        line.betaMin = Math.min(d2, d3);
        line.betaMax = Math.max(d2, d3);
        this.lines.add(line);
    }

    public void addHorizontalDivider(double d, double d2, double d3) {
        Line line = new Line();
        line.horizontal = true;
        line.alpha = d3;
        line.betaMin = Math.min(d, d2);
        line.betaMax = Math.max(d, d2);
        this.lines.add(line);
    }

    public SplitDockTree toTree() {
        Node node = this.tree();
        SplitDockTree splitDockTree = new SplitDockTree();
        if (node != null) {
            SplitDockTree.Key key = node.put(splitDockTree);
            splitDockTree.root(key);
        }
        return splitDockTree;
    }

    protected List<Line> getLines() {
        return this.lines;
    }

    protected List<Node> getNodes() {
        return this.nodes;
    }

    protected Node tree() {
        ArrayList<Node> arrayList = new ArrayList<Node>(this.nodes);
        if (arrayList.isEmpty()) {
            return null;
        }
        while (arrayList.size() > 1) {
            int n = arrayList.size();
            int n2 = 0;
            int n3 = 0;
            double d = Double.MAX_VALUE;
            for (int i = 0; i < n; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    double d2 = this.diff((Node)arrayList.get(i), (Node)arrayList.get(j));
                    if (!(d2 < d)) continue;
                    d = d2;
                    n2 = i;
                    n3 = j;
                }
            }
            Node node = this.combine((Node)arrayList.remove(n3), (Node)arrayList.remove(n2));
            arrayList.add(node);
        }
        return (Node)arrayList.get(0);
    }

    protected Node combine(Node node, Node node2) {
        double d = Math.min(node.x, node2.x);
        double d2 = Math.min(node.y, node2.y);
        double d3 = Math.max(node.x + node.width, node2.x + node2.width) - d;
        double d4 = Math.max(node.y + node.height, node2.y + node2.height) - d2;
        double d5 = node.x + node.width / 2.0;
        double d6 = node.y + node.height / 2.0;
        double d7 = node2.x + node2.width / 2.0;
        double d8 = node2.y + node2.height / 2.0;
        double d9 = (d5 - d7) * d4;
        double d10 = (d6 - d8) * d3;
        Node node3 = new Node();
        if (Math.abs(d9) > Math.abs(d10)) {
            node3.horizontal = true;
            if (d9 > 0.0) {
                node3.childA = node2;
                node3.childB = node;
            } else {
                node3.childA = node;
                node3.childB = node2;
            }
            double d11 = ((node3.childA.x + node3.childA.width + node3.childB.x) / 2.0 - d) / d3;
            Line line = this.bestFittingLine(d, d2, d3, d4, false, d11);
            node3.divider = line == null ? d11 : (line.alpha - d) / d3;
        } else {
            node3.horizontal = false;
            if (d10 > 0.0) {
                node3.childA = node2;
                node3.childB = node;
            } else {
                node3.childA = node;
                node3.childB = node2;
            }
            double d12 = ((node3.childA.y + node3.childA.height + node3.childB.y) / 2.0 - d2) / d4;
            Line line = this.bestFittingLine(d, d2, d3, d4, true, d12);
            node3.divider = line == null ? d12 : (line.alpha - d2) / d4;
        }
        node3.x = d;
        node3.y = d2;
        node3.width = d3;
        node3.height = d4;
        return node3;
    }

    protected double diff(Node node, Node node2) {
        double d = Math.min(node.x, node2.x);
        double d2 = Math.min(node.y, node2.y);
        double d3 = Math.max(node.x + node.width, node2.x + node2.width) - d;
        double d4 = Math.max(node.y + node.height, node2.y + node2.height) - d2;
        double d5 = node.width * node.height;
        double d6 = node2.width * node2.height;
        double d7 = d3 * d4;
        double d8 = (d7 - d5 - d6) / d7;
        for (Line line : this.lines) {
            d8 += this.penalty(d, d2, d3, d4, line);
        }
        return d8;
    }

    protected Line bestFittingLine(double d, double d2, double d3, double d4, boolean bl, double d5) {
        Line line = null;
        double d6 = Double.MAX_VALUE;
        for (Line line2 : this.lines) {
            double d7;
            double d8;
            double d9;
            double d10;
            if (line2.horizontal != bl) continue;
            if (line2.horizontal) {
                if (d2 > line2.alpha || d2 + d4 < line2.alpha || d + d3 < line2.betaMin || d > line2.betaMax) continue;
                d10 = Math.min(d, line2.betaMin);
                d9 = Math.max(d + d3, line2.betaMax);
                d8 = d9 - d10 - Math.min(line2.betaMax - line2.betaMin, d3);
                d7 = d8 / (d9 - d10);
                d7 *= 1.0 + Math.abs(d5 - line2.alpha) / d4;
            } else {
                if (d > line2.alpha || d + d3 < line2.alpha || d2 + d4 < line2.betaMin || d2 > line2.betaMax) continue;
                d10 = Math.min(d2, line2.betaMin);
                d9 = Math.max(d2 + d4, line2.betaMax);
                d8 = d9 - d10 - Math.min(line2.betaMax - line2.betaMin, d4);
                d7 = d8 / (d9 - d10);
                d7 *= 1.0 + Math.abs(d5 - line2.alpha) / d3;
            }
            if (!(d7 < 0.25) || !(d7 < d6)) continue;
            d6 = d7;
            line = line2;
        }
        return line;
    }

    protected double penalty(double d, double d2, double d3, double d4, Line line) {
        double d5;
        double d6;
        double d7;
        if (line.horizontal) {
            if (d2 > line.alpha || d2 + d4 < line.alpha) {
                return 0.0;
            }
            if (d + d3 < line.betaMin || d > line.betaMax) {
                return 0.0;
            }
            d7 = Math.min(d, line.betaMin);
            d6 = Math.max(d + d3, line.betaMax);
            d5 = d6 - d7 - Math.min(line.betaMax - line.betaMin, d3);
        } else {
            if (d > line.alpha || d + d3 < line.alpha) {
                return 0.0;
            }
            if (d2 + d4 < line.betaMin || d2 > line.betaMax) {
                return 0.0;
            }
            d7 = Math.min(d2, line.betaMin);
            d6 = Math.max(d2 + d4, line.betaMax);
            d5 = d6 - d7 - Math.min(line.betaMax - line.betaMin, d4);
        }
        return d5 / (d6 - d7);
    }

    protected static class Node {
        public double x;
        public double y;
        public double width;
        public double height;
        public Node childA;
        public Node childB;
        public double divider;
        public boolean horizontal;
        public Dockable[] dockables;
        public Dockable selected;

        protected Node() {
        }

        public SplitDockTree.Key put(SplitDockTree splitDockTree) {
            if (this.dockables != null) {
                return splitDockTree.put(this.dockables, this.selected);
            }
            if (this.horizontal) {
                return splitDockTree.horizontal(this.childA.put(splitDockTree), this.childB.put(splitDockTree), this.divider);
            }
            return splitDockTree.vertical(this.childA.put(splitDockTree), this.childB.put(splitDockTree), this.divider);
        }
    }

    protected static class Line {
        public boolean horizontal;
        public double alpha;
        public double betaMin;
        public double betaMax;

        protected Line() {
        }
    }
}

