/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.security.SecureScreenDockDialog;
import bibliothek.gui.dock.station.screen.ScreenDockDialog;
import bibliothek.gui.dock.station.screen.ScreenDockFrame;
import bibliothek.gui.dock.station.screen.ScreenDockFullscreenStrategy;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.Window;

public class DefaultScreenDockFullscreenStrategy
implements ScreenDockFullscreenStrategy {
    public void install(ScreenDockStation screenDockStation) {
    }

    public void uninstall(ScreenDockStation screenDockStation) {
    }

    public boolean isFullscreen(ScreenDockWindow screenDockWindow) {
        if (screenDockWindow instanceof ScreenDockDialog) {
            return this.isFullscreen(screenDockWindow, ((ScreenDockDialog)screenDockWindow).getDialog());
        }
        if (screenDockWindow instanceof SecureScreenDockDialog) {
            return this.isFullscreen(screenDockWindow, ((SecureScreenDockDialog)screenDockWindow).getDialog());
        }
        if (screenDockWindow instanceof ScreenDockFrame) {
            return this.isFullscreen(screenDockWindow, ((ScreenDockFrame)screenDockWindow).getFrame());
        }
        return false;
    }

    public boolean isFullscreen(ScreenDockWindow screenDockWindow, Window window) {
        GraphicsConfiguration graphicsConfiguration = window.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            return false;
        }
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Rectangle rectangle2 = window.getBounds();
        rectangle2 = new Rectangle(rectangle2.x - 1, rectangle2.y - 1, rectangle2.width + 2, rectangle2.height + 2);
        return rectangle2.contains(rectangle) && screenDockWindow.getNormalBounds() != null;
    }

    public void setFullscreen(ScreenDockWindow screenDockWindow, boolean bl) {
        if (screenDockWindow instanceof ScreenDockDialog) {
            this.setFullscreen(screenDockWindow, ((ScreenDockDialog)screenDockWindow).getDialog(), bl);
        }
        if (screenDockWindow instanceof SecureScreenDockDialog) {
            this.setFullscreen(screenDockWindow, ((SecureScreenDockDialog)screenDockWindow).getDialog(), bl);
        }
        if (screenDockWindow instanceof ScreenDockFrame) {
            this.setFullscreen(screenDockWindow, ((ScreenDockFrame)screenDockWindow).getFrame(), bl);
        }
    }

    public void setFullscreen(ScreenDockWindow screenDockWindow, Window window, boolean bl) {
        if (this.isFullscreen(screenDockWindow, window) != bl) {
            if (bl) {
                GraphicsConfiguration graphicsConfiguration = window.getGraphicsConfiguration();
                if (graphicsConfiguration != null) {
                    Rectangle rectangle = graphicsConfiguration.getBounds();
                    screenDockWindow.setNormalBounds(screenDockWindow.getWindowBounds());
                    window.setBounds(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
                }
            } else {
                Rectangle rectangle = screenDockWindow.getNormalBounds();
                if (rectangle != null) {
                    window.setBounds(rectangle);
                    screenDockWindow.setNormalBounds(null);
                }
            }
        }
    }
}

