/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.displayer;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.displayer.EclipseBasicDockableDisplayer;
import bibliothek.extension.gui.dock.theme.eclipse.displayer.EclipseDockableDisplayer;
import bibliothek.extension.gui.dock.theme.eclipse.displayer.NoTitleDisplayer;
import bibliothek.extension.gui.dock.theme.eclipse.rex.RexSystemColor;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayer;
import bibliothek.gui.dock.title.DockTitle;
import javax.swing.JComponent;
import javax.swing.border.LineBorder;

public class EclipseDisplayerFactory
implements DisplayerFactory {
    private EclipseTheme theme;

    public EclipseDisplayerFactory(EclipseTheme eclipseTheme) {
        this.theme = eclipseTheme;
    }

    public DockableDisplayer create(DockStation dockStation, Dockable dockable, DockTitle dockTitle) {
        EclipseThemeConnector.TitleBar titleBar = this.theme.getThemeConnector(dockStation.getController()).getTitleBarKind(dockable);
        switch (titleBar) {
            case NONE: 
            case NONE_BORDERED: 
            case NONE_HINTED: 
            case NONE_HINTED_BORDERED: {
                return new NoTitleDisplayer(dockStation, dockable, titleBar);
            }
            case ECLIPSE: {
                return new EclipseDockableDisplayer(this.theme, dockStation, dockable);
            }
            case BASIC_BORDERED: {
                BasicDockableDisplayer basicDockableDisplayer = this.create(dockStation, dockable, dockTitle, true, titleBar);
                if (basicDockableDisplayer.getComponent() instanceof JComponent) {
                    ((JComponent)basicDockableDisplayer.getComponent()).setBorder(new LineBorder(RexSystemColor.getBorderColor()));
                }
                return basicDockableDisplayer;
            }
        }
        BasicDockableDisplayer basicDockableDisplayer = this.create(dockStation, dockable, dockTitle, false, titleBar);
        if (basicDockableDisplayer.getComponent() instanceof JComponent) {
            ((JComponent)basicDockableDisplayer.getComponent()).setBorder(null);
        }
        return basicDockableDisplayer;
    }

    protected BasicDockableDisplayer create(DockStation dockStation, Dockable dockable, DockTitle dockTitle, boolean bl, EclipseThemeConnector.TitleBar titleBar) {
        DockableDisplayer.Location location = DockableDisplayer.Location.TOP;
        if (dockable.asDockStation() != null) {
            location = DockableDisplayer.Location.LEFT;
        }
        EclipseBasicDockableDisplayer eclipseBasicDockableDisplayer = bl ? new EclipseBasicDockableDisplayer(dockStation, dockable, dockTitle, location, titleBar){

            public void updateUI() {
                super.updateUI();
                this.setBorder(new LineBorder(RexSystemColor.getBorderColor()));
            }
        } : new EclipseBasicDockableDisplayer(dockStation, dockable, dockTitle, location, titleBar);
        return eclipseBasicDockableDisplayer;
    }
}

