/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode.status;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.facile.mode.LocationModeManager;
import bibliothek.gui.dock.facile.mode.status.AbstractExtendedModeEnablement;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablement;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablementFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExtendedModeEnablement
extends AbstractExtendedModeEnablement {
    public static final ExtendedModeEnablementFactory FACTORY = new ExtendedModeEnablementFactory(){

        @Override
        public ExtendedModeEnablement create(LocationModeManager<?> locationModeManager) {
            return new DefaultExtendedModeEnablement(locationModeManager);
        }
    };
    private CDockablePropertyListener listener = new CDockableAdapter(){

        public void minimizableChanged(CDockable cDockable) {
            DefaultExtendedModeEnablement.this.fire(cDockable.intern(), ExtendedMode.MINIMIZED, DefaultExtendedModeEnablement.this.isAvailable(cDockable.intern(), ExtendedMode.MINIMIZED));
        }

        public void maximizableChanged(CDockable cDockable) {
            DefaultExtendedModeEnablement.this.fire(cDockable.intern(), ExtendedMode.MAXIMIZED, DefaultExtendedModeEnablement.this.isAvailable(cDockable.intern(), ExtendedMode.MAXIMIZED));
        }

        public void externalizableChanged(CDockable cDockable) {
            DefaultExtendedModeEnablement.this.fire(cDockable.intern(), ExtendedMode.EXTERNALIZED, DefaultExtendedModeEnablement.this.isAvailable(cDockable.intern(), ExtendedMode.EXTERNALIZED));
        }
    };

    public DefaultExtendedModeEnablement(LocationModeManager<?> locationModeManager) {
        super(locationModeManager);
        this.init();
    }

    @Override
    protected void connect(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            ((CommonDockable)dockable).getDockable().addCDockablePropertyListener(this.listener);
        }
    }

    @Override
    protected void disconnect(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            ((CommonDockable)dockable).getDockable().removeCDockablePropertyListener(this.listener);
        }
    }

    @Override
    public boolean isAvailable(Dockable dockable, ExtendedMode extendedMode) {
        Object object;
        if (extendedMode == ExtendedMode.NORMALIZED) {
            return true;
        }
        if (dockable instanceof CommonDockable) {
            object = ((CommonDockable)dockable).getDockable();
            if (extendedMode == ExtendedMode.EXTERNALIZED) {
                return object.isExternalizable();
            }
            if (extendedMode == ExtendedMode.MAXIMIZED) {
                return object.isMaximizable();
            }
            if (extendedMode == ExtendedMode.MINIMIZED) {
                return object.isMinimizable();
            }
        }
        if ((object = dockable.asDockStation()) != null) {
            int n = object.getDockableCount();
            for (int i = 0; i < n; ++i) {
                boolean bl = this.isAvailable(object.getDockable(i), extendedMode);
                if (bl) continue;
                return false;
            }
            return true;
        }
        return true;
    }
}

