/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.theme;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.gui.DockController;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.action.CPanelPopup;
import bibliothek.gui.dock.common.intern.action.panel.EclipsePanelPopupGenerator;
import bibliothek.gui.dock.common.intern.action.panel.PanelDropDownGenerator;
import bibliothek.gui.dock.common.intern.action.panel.PanelMenuGenerator;
import bibliothek.gui.dock.common.intern.color.BasicButtonTitleTransmitter;
import bibliothek.gui.dock.common.intern.color.EclipseTabTransmitter;
import bibliothek.gui.dock.common.intern.font.FontBridgeFactory;
import bibliothek.gui.dock.common.intern.font.TabTitleFontTransmitter;
import bibliothek.gui.dock.common.theme.CDockTheme;
import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.themes.NoStackTheme;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.themes.font.TitleFont;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.font.FontBridge;
import bibliothek.gui.dock.util.font.FontManager;
import java.util.Map;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CEclipseTheme
extends CDockTheme<EclipseTheme> {
    public CEclipseTheme(CControl cControl, EclipseTheme eclipseTheme) {
        super(eclipseTheme);
        this.init(cControl);
    }

    public CEclipseTheme(CControl cControl) {
        this(new EclipseTheme());
        this.init(cControl);
    }

    private CEclipseTheme(EclipseTheme eclipseTheme) {
        super(eclipseTheme, new NoStackTheme(eclipseTheme));
    }

    private void init(final CControl cControl) {
        this.putColorBridgeFactory(TabColor.KIND_TAB_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager colorManager) {
                EclipseTabTransmitter eclipseTabTransmitter = new EclipseTabTransmitter(colorManager);
                eclipseTabTransmitter.setControl(cControl);
                return eclipseTabTransmitter;
            }
        });
        this.putColorBridgeFactory(TitleColor.KIND_FLAP_BUTTON_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager colorManager) {
                BasicButtonTitleTransmitter basicButtonTitleTransmitter = new BasicButtonTitleTransmitter(colorManager);
                basicButtonTitleTransmitter.setControl(cControl);
                return basicButtonTitleTransmitter;
            }
        });
        this.initDefaultFontBridges(cControl);
        this.putFontBridgeFactory(TitleFont.KIND_TAB_TITLE_FONT, new FontBridgeFactory(){

            public FontBridge create(FontManager fontManager) {
                TabTitleFontTransmitter tabTitleFontTransmitter = new TabTitleFontTransmitter(fontManager);
                tabTitleFontTransmitter.setControl(cControl);
                return tabTitleFontTransmitter;
            }
        });
    }

    @Override
    public void install(DockController dockController) {
        super.install(dockController);
        IconManager iconManager = dockController.getIcons();
        Map<String, Icon> map = DockUtilities.loadIcons("data/bibliothek/gui/dock/icons/eclipse/icons.ini", "data/bibliothek/gui/dock/icons/eclipse/", CEclipseTheme.class.getClassLoader());
        for (Map.Entry<String, Icon> entry : map.entrySet()) {
            iconManager.setIconTheme(entry.getKey(), entry.getValue());
        }
        ActionViewConverter actionViewConverter = dockController.getActionViewConverter();
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.TITLE, new EclipsePanelPopupGenerator());
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.MENU, new PanelMenuGenerator());
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.DROP_DOWN, new PanelDropDownGenerator());
    }

    @Override
    public void uninstall(DockController dockController) {
        super.uninstall(dockController);
        dockController.getIcons().clearThemeIcons();
        ActionViewConverter actionViewConverter = dockController.getActionViewConverter();
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.TITLE, null);
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.MENU, null);
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.DROP_DOWN, null);
    }
}

