/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.theme;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.intern.font.ButtonFontTransmitter;
import bibliothek.gui.dock.common.intern.font.FontBridgeFactory;
import bibliothek.gui.dock.common.intern.font.TabFontTransmitter;
import bibliothek.gui.dock.common.intern.font.TitleFontTransmitter;
import bibliothek.gui.dock.common.theme.color.CColorBridge;
import bibliothek.gui.dock.common.theme.color.CColorBridgeExtension;
import bibliothek.gui.dock.common.theme.color.ExtendedColorBridge;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.focus.DockableSelection;
import bibliothek.gui.dock.station.Combiner;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.themes.DockThemeExtension;
import bibliothek.gui.dock.themes.font.TabFont;
import bibliothek.gui.dock.themes.font.TitleFont;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.UIProperties;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.extension.ExtensionName;
import bibliothek.gui.dock.util.font.FontBridge;
import bibliothek.gui.dock.util.font.FontManager;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDockTheme<D extends DockTheme>
implements DockTheme {
    private D theme;
    private DockTheme delegate;
    private Map<Path, ColorBridgeFactory> colorBridgeFactories = new HashMap<Path, ColorBridgeFactory>();
    private Map<Path, FontBridgeFactory> fontBridgeFactories = new HashMap<Path, FontBridgeFactory>();
    private List<Controller> controllers = new ArrayList<Controller>();
    private DockThemeExtension[] extensions;

    public CDockTheme(D d) {
        this(d, (DockTheme)d);
    }

    public CDockTheme(D d, DockTheme dockTheme) {
        if (d == null) {
            throw new IllegalArgumentException("theme must not be null");
        }
        if (dockTheme == null) {
            throw new IllegalArgumentException("delegate must not be null");
        }
        this.theme = d;
        this.delegate = dockTheme;
    }

    protected void initDefaultFontBridges(final CControl cControl) {
        this.putFontBridgeFactory(TitleFont.KIND_TITLE_FONT, new FontBridgeFactory(){

            public FontBridge create(FontManager fontManager) {
                TitleFontTransmitter titleFontTransmitter = new TitleFontTransmitter(fontManager);
                titleFontTransmitter.setControl(cControl);
                return titleFontTransmitter;
            }
        });
        this.putFontBridgeFactory(TitleFont.KIND_FLAP_BUTTON_FONT, new FontBridgeFactory(){

            public FontBridge create(FontManager fontManager) {
                ButtonFontTransmitter buttonFontTransmitter = new ButtonFontTransmitter(fontManager);
                buttonFontTransmitter.setControl(cControl);
                return buttonFontTransmitter;
            }
        });
        this.putFontBridgeFactory(TabFont.KIND_TAB_FONT, new FontBridgeFactory(){

            public FontBridge create(FontManager fontManager) {
                TabFontTransmitter tabFontTransmitter = new TabFontTransmitter(fontManager);
                tabFontTransmitter.setControl(cControl);
                return tabFontTransmitter;
            }
        });
    }

    public D intern() {
        return this.theme;
    }

    @Override
    public Combiner getCombiner(DockStation dockStation) {
        return this.delegate.getCombiner(dockStation);
    }

    @Override
    public DisplayerFactory getDisplayFactory(DockStation dockStation) {
        return this.delegate.getDisplayFactory(dockStation);
    }

    @Override
    public DockableMovingImageFactory getMovingImageFactory(DockController dockController) {
        return this.delegate.getMovingImageFactory(dockController);
    }

    @Override
    public StationPaint getPaint(DockStation dockStation) {
        return this.delegate.getPaint(dockStation);
    }

    @Override
    public DockTitleFactory getTitleFactory(DockController dockController) {
        return this.delegate.getTitleFactory(dockController);
    }

    @Override
    public DockableSelection getDockableSelection(DockController dockController) {
        return this.delegate.getDockableSelection(dockController);
    }

    public void putColorBridgeFactory(Path path, ColorBridgeFactory colorBridgeFactory) {
        this.colorBridgeFactories.put(path, colorBridgeFactory);
        for (Controller controller : this.controllers) {
            ColorBridge colorBridge;
            ColorManager colorManager = controller.controller.getColors();
            ColorBridge colorBridge2 = controller.colors.remove(path);
            ColorBridge colorBridge3 = colorBridge = colorBridgeFactory == null ? null : colorBridgeFactory.create(colorManager);
            if (colorBridge == null) {
                controller.colors.remove(path);
                if (colorBridge2 == null) continue;
                colorManager.unpublish(Priority.DEFAULT, path);
                continue;
            }
            controller.colors.put(path, colorBridge);
            colorManager.publish(Priority.DEFAULT, path, colorBridge);
        }
    }

    public void putFontBridgeFactory(Path path, FontBridgeFactory fontBridgeFactory) {
        this.fontBridgeFactories.put(path, fontBridgeFactory);
        for (Controller controller : this.controllers) {
            FontBridge fontBridge;
            FontManager fontManager = controller.controller.getFonts();
            FontBridge fontBridge2 = controller.fonts.remove(path);
            FontBridge fontBridge3 = fontBridge = fontBridgeFactory == null ? null : fontBridgeFactory.create(fontManager);
            if (fontBridge == null) {
                controller.fonts.remove(path);
                if (fontBridge2 == null) continue;
                fontManager.unpublish(Priority.DEFAULT, path);
                continue;
            }
            controller.fonts.put(path, fontBridge);
            fontManager.publish(Priority.DEFAULT, path, fontBridge);
        }
    }

    @Override
    public void install(DockController dockController, DockThemeExtension[] dockThemeExtensionArray) {
        if (this.extensions != null) {
            throw new IllegalStateException("theme is already in use");
        }
        this.extensions = dockThemeExtensionArray;
        for (DockThemeExtension dockThemeExtension : dockThemeExtensionArray) {
            dockThemeExtension.install(dockController, this);
        }
        this.delegate.install(dockController, dockThemeExtensionArray);
        this.install(dockController);
        for (DockThemeExtension dockThemeExtension : dockThemeExtensionArray) {
            dockThemeExtension.installed(dockController, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void install(DockController dockController) {
        Object object;
        Controller controller = new Controller();
        controller.controller = dockController;
        ColorManager colorManager = dockController.getColors();
        CControl cControl = dockController.getProperties().get(CControl.CCONTROL);
        try {
            colorManager.lockUpdate();
            object = new ExtensionName<CColorBridgeExtension>(CColorBridgeExtension.EXTENSION_NAME, CColorBridgeExtension.class, "theme", this);
            List<CColorBridgeExtension> list = dockController.getExtensions().load(object);
            for (Map.Entry<Path, ColorBridgeFactory> entry : this.colorBridgeFactories.entrySet()) {
                ColorBridge colorBridge = entry.getValue().create(colorManager);
                Path path = entry.getKey();
                ArrayList<CColorBridgeExtension> arrayList = new ArrayList<CColorBridgeExtension>();
                CColorBridge[] cColorBridgeArray = list.iterator();
                while (cColorBridgeArray.hasNext()) {
                    CColorBridgeExtension cColorBridgeExtension = (CColorBridgeExtension)cColorBridgeArray.next();
                    if (!path.equals(cColorBridgeExtension.getKey())) continue;
                    arrayList.add(cColorBridgeExtension);
                }
                if (!arrayList.isEmpty()) {
                    cColorBridgeArray = new CColorBridge[arrayList.size()];
                    for (int i = 0; i < cColorBridgeArray.length; ++i) {
                        cColorBridgeArray[i] = ((CColorBridgeExtension)arrayList.get(i)).create(cControl, colorManager);
                    }
                    colorBridge = new ExtendedColorBridge(colorBridge, cColorBridgeArray);
                }
                colorManager.publish(Priority.DEFAULT, entry.getKey(), colorBridge);
                controller.colors.put(entry.getKey(), colorBridge);
            }
        }
        finally {
            colorManager.unlockUpdate();
        }
        object = dockController.getFonts();
        try {
            ((UIProperties)object).lockUpdate();
            for (Map.Entry entry : this.fontBridgeFactories.entrySet()) {
                FontBridge fontBridge = ((FontBridgeFactory)entry.getValue()).create((FontManager)object);
                ((UIProperties)object).publish(Priority.DEFAULT, (Path)entry.getKey(), fontBridge);
                controller.fonts.put((Path)entry.getKey(), fontBridge);
            }
        }
        finally {
            ((UIProperties)object).unlockUpdate();
        }
        this.controllers.add(controller);
    }

    @Override
    public void uninstall(DockController dockController) {
        this.delegate.uninstall(dockController);
        int n = this.controllers.size();
        for (int i = 0; i < n; ++i) {
            Controller controller = this.controllers.get(i);
            if (controller.controller != dockController) continue;
            this.controllers.remove(i--);
            --n;
            ColorManager object2 = dockController.getColors();
            for (ColorBridge colorBridge : controller.colors.values()) {
                object2.unpublish(Priority.DEFAULT, colorBridge);
            }
            FontManager fontManager = dockController.getFonts();
            for (FontBridge fontBridge : controller.fonts.values()) {
                fontManager.unpublish(Priority.DEFAULT, fontBridge);
            }
        }
        for (DockThemeExtension dockThemeExtension : this.extensions) {
            dockThemeExtension.uninstall(dockController, this);
        }
        this.extensions = null;
    }

    private class Controller {
        public DockController controller;
        public Map<Path, ColorBridge> colors = new HashMap<Path, ColorBridge>();
        public Map<Path, FontBridge> fonts = new HashMap<Path, FontBridge>();

        private Controller() {
        }
    }
}

