/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.color;

import bibliothek.gui.dock.common.ColorMap;
import bibliothek.gui.dock.common.event.ColorMapListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.ui.UITransmitter;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.DockColor;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ColorTransmitter
extends UITransmitter<Color, DockColor>
implements ColorBridge {
    private Listener listener = new Listener();

    public ColorTransmitter(String ... stringArray) {
        super(stringArray);
    }

    protected Color getFirstNonNull(ColorMap colorMap, String ... stringArray) {
        for (String string : stringArray) {
            Color color = colorMap.getColor(string);
            if (color == null) continue;
            return color;
        }
        return null;
    }

    @Override
    protected void connect(CDockable cDockable) {
        cDockable.getColors().addListener(this.listener);
    }

    @Override
    protected void disconnect(CDockable cDockable) {
        cDockable.getColors().removeListener(this.listener);
    }

    private class Listener
    implements ColorMapListener {
        private Listener() {
        }

        public void colorChanged(ColorMap colorMap, String string, Color color) {
            ColorTransmitter.this.update(colorMap.getDockable(), string, color);
        }
    }
}

