/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.ColorMap;
import bibliothek.gui.dock.common.FontMap;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.event.CDockableStateListener;
import bibliothek.gui.dock.common.event.CDoubleClickListener;
import bibliothek.gui.dock.common.event.CFocusListener;
import bibliothek.gui.dock.common.event.CKeyboardListener;
import bibliothek.gui.dock.common.event.CVetoClosingListener;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CDockableAccess;
import bibliothek.gui.dock.common.intern.CListenerCollection;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.ControlVetoClosingListener;
import bibliothek.gui.dock.common.intern.action.CloseActionSource;
import bibliothek.gui.dock.common.layout.RequestDimension;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.event.VetoableDockFrontendEvent;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCDockable
implements CDockable {
    private CLocation location = null;
    private CommonDockable dockable;
    private CStation<?> workingArea;
    private CControlAccess control;
    private String uniqueId;
    private boolean resizeLockedVertically = false;
    private boolean resizeLockedHorizontally = false;
    private boolean minimizeHold = false;
    private Dimension minimizeSize = new Dimension(-1, -1);
    private RequestDimension resizeRequest;
    private ColorMap colors = new ColorMap(this);
    private FontMap fonts = new FontMap(this);
    private Map<String, CAction> actions = new HashMap<String, CAction>();
    private boolean titleShown = true;
    private boolean singleTabShown = false;
    protected CListenerCollection listenerCollection = new CListenerCollection();
    private ControlVetoClosingListener vetoClosingListenerConverter;
    private CloseActionSource close = new CloseActionSource(this);
    private Map<ExtendedMode, CLocation> defaultLocations = new HashMap<ExtendedMode, CLocation>(4);

    protected AbstractCDockable() {
    }

    protected abstract CommonDockable createCommonDockable();

    protected void init(CommonDockable commonDockable) {
        if (this.dockable != null) {
            throw new IllegalStateException("dockable already set");
        }
        if (commonDockable == null) {
            throw new NullPointerException("dockable is null");
        }
        this.dockable = commonDockable;
    }

    protected CloseActionSource getClose() {
        return this.close;
    }

    protected CControlAccess control() {
        return this.control;
    }

    @Override
    public void addCDockableStateListener(CDockableStateListener cDockableStateListener) {
        this.listenerCollection.addCDockableStateListener(cDockableStateListener);
    }

    @Override
    public void addCDockablePropertyListener(CDockablePropertyListener cDockablePropertyListener) {
        this.listenerCollection.addCDockablePropertyListener(cDockablePropertyListener);
    }

    @Override
    public void removeCDockableStateListener(CDockableStateListener cDockableStateListener) {
        this.listenerCollection.removeCDockableStateListener(cDockableStateListener);
    }

    @Override
    public void removeCDockablePropertyListener(CDockablePropertyListener cDockablePropertyListener) {
        this.listenerCollection.removeCDockablePropertyListener(cDockablePropertyListener);
    }

    @Override
    public void addFocusListener(CFocusListener cFocusListener) {
        this.listenerCollection.addFocusListener(cFocusListener);
    }

    @Override
    public void removeFocusListener(CFocusListener cFocusListener) {
        this.listenerCollection.removeFocusListener(cFocusListener);
    }

    @Override
    public void addKeyboardListener(CKeyboardListener cKeyboardListener) {
        this.listenerCollection.addKeyboardListener(cKeyboardListener);
    }

    @Override
    public void removeKeyboardListener(CKeyboardListener cKeyboardListener) {
        this.listenerCollection.removeKeyboardListener(cKeyboardListener);
    }

    @Override
    public void addDoubleClickListener(CDoubleClickListener cDoubleClickListener) {
        this.listenerCollection.addDoubleClickListener(cDoubleClickListener);
    }

    @Override
    public void removeDoubleClickListener(CDoubleClickListener cDoubleClickListener) {
        this.listenerCollection.removeDoubleClickListener(cDoubleClickListener);
    }

    @Override
    public void addVetoClosingListener(CVetoClosingListener cVetoClosingListener) {
        boolean bl = !this.listenerCollection.hasVetoClosingListeners();
        this.listenerCollection.addVetoClosingListener(cVetoClosingListener);
        if (bl && this.control != null) {
            this.control.getOwner().intern().addVetoableListener(this.getVetoClosingListenerConverter());
        }
    }

    @Override
    public void removeVetoClosingListener(CVetoClosingListener cVetoClosingListener) {
        this.listenerCollection.removeVetoClosingListener(cVetoClosingListener);
        if (!this.listenerCollection.hasVetoClosingListeners() && this.control != null && this.vetoClosingListenerConverter != null) {
            this.control.getOwner().intern().removeVetoableListener(this.vetoClosingListenerConverter);
            this.vetoClosingListenerConverter = null;
        }
    }

    private ControlVetoClosingListener getVetoClosingListenerConverter() {
        if (this.vetoClosingListenerConverter == null) {
            this.vetoClosingListenerConverter = new ControlVetoClosingListener(this.control.getOwner(), this.listenerCollection.getVetoClosingListener()){

                protected CDockable[] getCDockables(VetoableDockFrontendEvent vetoableDockFrontendEvent) {
                    for (Dockable dockable : vetoableDockFrontendEvent) {
                        if (dockable != AbstractCDockable.this.intern()) continue;
                        return new CDockable[]{AbstractCDockable.this};
                    }
                    return null;
                }
            };
        }
        return this.vetoClosingListenerConverter;
    }

    @Deprecated
    protected CDockableStateListener[] stateListeners() {
        return this.listenerCollection.getCDockableStateListeners();
    }

    @Deprecated
    protected CDockablePropertyListener[] propertyListeners() {
        return this.listenerCollection.getCDockablePropertyListeners();
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.control == null) {
            throw new IllegalStateException("This CDockable does not know its CControl. Call CControl.add(...) to connect this CDockable befor calling setVisible(...).");
        }
        if (bl) {
            this.control.show(this);
        } else {
            this.control.hide(this);
        }
    }

    @Override
    public boolean isVisible() {
        if (this.control == null) {
            return false;
        }
        return this.control.isVisible(this);
    }

    public void toFront() {
        if (this.isVisible()) {
            this.control.getOwner().intern().getController().setFocusedDockable(this.intern(), false);
        }
    }

    @Override
    public void setLocation(CLocation cLocation) {
        this.location = cLocation;
        if (cLocation != null && this.control != null && this.isVisible()) {
            this.control.getLocationManager().setLocation(this.intern(), cLocation);
            this.location = null;
        }
    }

    @Override
    public CLocation getBaseLocation() {
        if (this.control != null && this.isVisible()) {
            return this.control.getLocationManager().getLocation(this.intern());
        }
        return this.location;
    }

    @Override
    public void setExtendedMode(ExtendedMode extendedMode) {
        if (extendedMode == null) {
            throw new NullPointerException("extendedMode must not be null");
        }
        if (extendedMode == ExtendedMode.EXTERNALIZED && !this.isExternalizable()) {
            return;
        }
        if (extendedMode == ExtendedMode.MINIMIZED && !this.isMinimizable()) {
            return;
        }
        if (extendedMode == ExtendedMode.MAXIMIZED && !this.isMaximizable()) {
            return;
        }
        CControlAccess cControlAccess = this.control();
        if (cControlAccess != null) {
            cControlAccess.getLocationManager().setMode(this.intern(), extendedMode);
        }
    }

    @Override
    public ExtendedMode getExtendedMode() {
        CControlAccess cControlAccess = this.control();
        if (cControlAccess == null) {
            return null;
        }
        return cControlAccess.getLocationManager().getMode(this.intern());
    }

    @Override
    public void setWorkingArea(CStation<?> cStation) {
        this.workingArea = cStation;
    }

    @Override
    public CStation<?> getWorkingArea() {
        return this.workingArea;
    }

    public boolean isResizeLocked() {
        return this.resizeLockedVertically && this.resizeLockedHorizontally;
    }

    @Override
    public boolean isResizeLockedVertically() {
        return this.resizeLockedVertically;
    }

    @Override
    public boolean isResizeLockedHorizontally() {
        return this.resizeLockedHorizontally;
    }

    public void setResizeRequest(Dimension dimension, boolean bl) {
        RequestDimension requestDimension = this.resizeRequest = dimension == null ? null : new RequestDimension(dimension);
        if (bl && this.control != null) {
            this.control.getOwner().handleResizeRequests();
        }
    }

    public void setResizeRequest(RequestDimension requestDimension, boolean bl) {
        RequestDimension requestDimension2 = this.resizeRequest = requestDimension == null ? null : new RequestDimension(requestDimension);
        if (bl && this.control != null) {
            this.control.getOwner().handleResizeRequests();
        }
    }

    @Override
    public RequestDimension getAndClearResizeRequest() {
        RequestDimension requestDimension = this.resizeRequest;
        this.resizeRequest = null;
        return requestDimension;
    }

    public void setResizeLocked(boolean bl) {
        if (this.isResizeLocked() != bl) {
            this.resizeLockedHorizontally = bl;
            this.resizeLockedVertically = bl;
            this.listenerCollection.getCDockablePropertyListener().resizeLockedChanged(this);
        }
    }

    public void setResizeLockedHorizontally(boolean bl) {
        if (this.resizeLockedHorizontally != bl) {
            this.resizeLockedHorizontally = bl;
            this.listenerCollection.getCDockablePropertyListener().resizeLockedChanged(this);
        }
    }

    public void setResizeLockedVertically(boolean bl) {
        if (this.resizeLockedVertically != bl) {
            this.resizeLockedVertically = bl;
            this.listenerCollection.getCDockablePropertyListener().resizeLockedChanged(this);
        }
    }

    @Override
    public void setMinimizedHold(boolean bl) {
        if (this.minimizeHold != bl) {
            this.minimizeHold = bl;
            this.listenerCollection.getCDockablePropertyListener().minimizedHoldChanged(this);
        }
    }

    @Override
    public boolean isMinimizedHold() {
        return this.minimizeHold;
    }

    @Override
    public void setMinimizedSize(Dimension dimension) {
        this.minimizeSize = new Dimension(dimension.width, dimension.height);
        this.listenerCollection.getCDockablePropertyListener().minimizeSizeChanged(this);
    }

    @Override
    public Dimension getMinimizedSize() {
        return new Dimension(this.minimizeSize.width, this.minimizeSize.height);
    }

    public void setTitleShown(boolean bl) {
        if (this.titleShown != bl) {
            this.titleShown = bl;
            this.listenerCollection.getCDockablePropertyListener().titleShownChanged(this);
        }
    }

    @Override
    public boolean isTitleShown() {
        return this.titleShown;
    }

    public void setSingleTabShown(boolean bl) {
        if (this.singleTabShown != bl) {
            this.singleTabShown = bl;
            this.listenerCollection.getCDockablePropertyListener().singleTabShownChanged(this);
        }
    }

    @Override
    public boolean isSingleTabShown() {
        return this.singleTabShown;
    }

    @Override
    public CommonDockable intern() {
        if (this.dockable == null) {
            this.init(this.createCommonDockable());
        }
        return this.dockable;
    }

    public void setDefaultLocation(ExtendedMode extendedMode, CLocation cLocation) {
        if (extendedMode == null) {
            throw new IllegalArgumentException("mode must not be null");
        }
        if (cLocation == null) {
            this.defaultLocations.remove(extendedMode);
        } else {
            CLocationModeManager cLocationModeManager;
            ExtendedMode extendedMode2 = cLocation.findMode();
            if (extendedMode2 == null) {
                throw new IllegalArgumentException("location does not carry enough information to find its mode");
            }
            if (!extendedMode.getModeIdentifier().equals(extendedMode2.getModeIdentifier())) {
                throw new IllegalArgumentException("mode of location and 'mode' do not have the same identifier");
            }
            this.defaultLocations.put(extendedMode, cLocation);
            if (this.control != null && (cLocationModeManager = this.control.getLocationManager()).getLocation(this.intern(), extendedMode) == null) {
                cLocationModeManager.setLocation(this.intern(), extendedMode, cLocation);
            }
        }
    }

    public CLocation getDefaultLocation(ExtendedMode extendedMode) {
        return this.defaultLocations.get(extendedMode);
    }

    @Override
    public void setControl(CControlAccess cControlAccess) {
        if (this.control == cControlAccess) {
            return;
        }
        if (this.control != null) {
            if (this.control.shouldStore(this) == null) {
                this.control.getLocationManager().remove(this.intern());
            } else {
                this.control.getLocationManager().reduceToEmpty(this.intern());
            }
            this.control.getLocationManager().remove(this.intern());
            this.control.link(this, null);
            if (this.vetoClosingListenerConverter != null) {
                this.control.getOwner().intern().removeVetoableListener(this.vetoClosingListenerConverter);
                this.vetoClosingListenerConverter = null;
            }
        }
        this.control = cControlAccess;
        if (cControlAccess != null) {
            if (this.uniqueId != null) {
                cControlAccess.getLocationManager().add(this.uniqueId, this.intern());
            }
            if (this.listenerCollection.hasVetoClosingListeners()) {
                cControlAccess.getOwner().intern().addVetoableListener(this.getVetoClosingListenerConverter());
            }
            cControlAccess.link(this, new CDockableAccess(){
                private ExtendedMode currentMode;

                public void informVisibility(boolean bl) {
                    AbstractCDockable.this.listenerCollection.getCDockableStateListener().visibilityChanged(AbstractCDockable.this);
                }

                public void informMode(ExtendedMode extendedMode) {
                    if (this.currentMode != extendedMode) {
                        this.currentMode = extendedMode;
                        CDockableStateListener cDockableStateListener = AbstractCDockable.this.listenerCollection.getCDockableStateListener();
                        if (extendedMode == ExtendedMode.EXTERNALIZED) {
                            cDockableStateListener.externalized(AbstractCDockable.this);
                        } else if (extendedMode == ExtendedMode.MINIMIZED) {
                            cDockableStateListener.minimized(AbstractCDockable.this);
                        } else if (extendedMode == ExtendedMode.MAXIMIZED) {
                            cDockableStateListener.maximized(AbstractCDockable.this);
                        } else if (extendedMode == ExtendedMode.NORMALIZED) {
                            cDockableStateListener.normalized(AbstractCDockable.this);
                        }
                    }
                }

                public CFocusListener getFocusListener() {
                    return AbstractCDockable.this.listenerCollection.getFocusListener();
                }

                public CKeyboardListener getKeyboardListener() {
                    return AbstractCDockable.this.listenerCollection.getKeyboardListener();
                }

                public CDoubleClickListener getDoubleClickListener() {
                    return AbstractCDockable.this.listenerCollection.getDoubleClickListener();
                }

                public void setUniqueId(String string) {
                    if (string != null && !string.equals(AbstractCDockable.this.uniqueId) || string == null && AbstractCDockable.this.uniqueId != null) {
                        CLocationModeManager cLocationModeManager;
                        if (AbstractCDockable.this.control != null && AbstractCDockable.this.uniqueId != null) {
                            cLocationModeManager = AbstractCDockable.this.control.getLocationManager();
                            cLocationModeManager.remove(AbstractCDockable.this.intern());
                        }
                        AbstractCDockable.this.uniqueId = string;
                        if (AbstractCDockable.this.control != null && string != null) {
                            cLocationModeManager = AbstractCDockable.this.control.getLocationManager();
                            cLocationModeManager.put(AbstractCDockable.this.uniqueId, AbstractCDockable.this.intern());
                            for (Map.Entry entry : AbstractCDockable.this.defaultLocations.entrySet()) {
                                if (cLocationModeManager.getLocation(AbstractCDockable.this.intern(), (ExtendedMode)entry.getKey()) != null) continue;
                                cLocationModeManager.setLocation(AbstractCDockable.this.intern(), (ExtendedMode)entry.getKey(), (CLocation)entry.getValue());
                            }
                        }
                    }
                }

                public String getUniqueId() {
                    return AbstractCDockable.this.uniqueId;
                }

                public CLocation internalLocation() {
                    CLocation cLocation = AbstractCDockable.this.location;
                    AbstractCDockable.this.location = null;
                    return cLocation;
                }
            });
        }
        this.close.setControl(cControlAccess);
    }

    public void putAction(String string, CAction cAction) {
        CAction cAction2 = this.actions.put(string, cAction);
        if (cAction2 != cAction) {
            this.listenerCollection.getCDockablePropertyListener().actionChanged(this, string, cAction2, cAction);
        }
    }

    @Override
    public CAction getAction(String string) {
        return this.actions.get(string);
    }

    @Override
    public ColorMap getColors() {
        return this.colors;
    }

    @Override
    public FontMap getFonts() {
        return this.fonts;
    }

    @Override
    public CControlAccess getControl() {
        return this.control;
    }
}

