% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectralNMF.R
\name{spectralNMFList}
\alias{spectralNMFList}
\title{Perform Non-Negative Matrix factorization on list of SPC files}
\usage{
spectralNMFList(objectList, rank, method = "PGNMF", initSpectralData = NULL,
  nruns = 10, subsamplingFactor = 3, checkDivergence = TRUE)
}
\arguments{
\item{objectList}{list of SPC files}

\item{rank}{number of NMF components to be found}

\item{method}{name of the NMF method to be used, consult the help
of the 'nmf' function from the NMF package for the methods available by default}

\item{initSpectralData}{list of SPC files containing pure component spectra}

\item{nruns}{number of NMF runs.}

\item{subsamplingFactor}{subsampling factor used during NMF analysis}

\item{checkDivergence}{Boolean indicating whether divergence checking should be performed}
}
\value{
list of NMF models
}
\description{
Perform Non-Negative Matrix factorization on list of SPC files
}
\author{
Nicolas Sauwen
}
