% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliermethods.R
\name{xknn}
\alias{xknn}
\title{k-nearest neighbors for outlier detection}
\usage{
xknn(
  data,
  output,
  exclude = NULL,
  metric = "manhattan",
  mode = "soft",
  pc = FALSE,
  boot = FALSE,
  var,
  pcvar = NULL
)
}
\arguments{
\item{data}{Data frame of species records with environmental data.}

\item{output}{Either clean: for data frame with no suspicious outliers or outlier: to return dataframe with only outliers.}

\item{exclude}{Exclude variables that should not be considered in the fitting the one class model, for example x and y columns or
latitude/longitude or any column that the user doesn't want to consider.}

\item{metric}{The different metric distances to compute the distances among the environmental predictors. See \code{dist} function and
how te different distances are applied. The different measures are allowed including
\code{"euclidean", "maximum", "manhattan", "canberra", "binary"}.}

\item{mode}{This includes \code{soft} when the outliers are removed using mean to compute the z-scores or \code{robust} when
median absolute deviation.}

\item{pc}{Whether principal component analysis will be computed. Default \code{FALSE}}

\item{boot}{Whether bootstrapping will be computed. Default \code{FALSE}}

\item{var}{The variable of concern, which is vital for univariate outlier detection methods}

\item{pcvar}{Principal component analysis to e used for outlier detection after PCA. Default \code{PC1}}
}
\value{
Dataframe with or with no outliers.
}
\description{
k-nearest neighbors for outlier detection
}
\examples{
\donttest{

data("efidata")

danube <- system.file('extdata/danube.shp.zip', package='specleanr')

db <- sf::st_read(danube, quiet=TRUE)

wcd <- terra::rast(system.file('extdata/worldclim.tiff', package='specleanr'))

refdata <- pred_extract(data = efidata, raster= wcd ,
                       lat = 'decimalLatitude',
                       lon= 'decimalLongitude',
                       colsp = "scientificName",
                       bbox = db,
                       minpts = 10)

lofout <- xknn(data = refdata[["Thymallus thymallus"]], exclude = c("x", "y"),
                output='outlier', metric ='manhattan',
                 mode = "soft")

}
}
