% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWaveletPeaks.R
\name{getWaveletPeaks}
\alias{getWaveletPeaks}
\title{Convert raw NMR spectra to peak data by using wavelets}
\usage{
getWaveletPeaks(Y.spec, X.ppm, sample.labels = NULL, window.width = "small",
  window.split = 4, scales = seq(1, 16, 1), baselineThresh = 1000,
  SNR.Th = -1, nCPU = -1, include_nearbyPeaks = TRUE)
}
\arguments{
\item{Y.spec}{The spectra in matrix format.}

\item{X.ppm}{The x/ppm values of the spectra (in single vector or matrix format).}

\item{sample.labels}{The sample labels (numeric), if not supplied these will simply be the sample numbers.}

\item{window.width}{The width of the detection window for the wavelets. Because of the Fourier transform lengths of 512 ( window.width = 'small') of 1024 ( window.width = 'large') are preferable.}

\item{window.split}{A positive, even and whole number indicating in how many parts the sliding window is split up. With every iteration the window slides one part further.}

\item{scales}{The scales to be used in the wavelet based peak detection, see \link[MassSpecWavelet]{peakDetectionCWT}.}

\item{baselineThresh}{Peaks with a peakValue lower than this threshold will be removed (default = 1000).}

\item{SNR.Th}{The Signal-to-noise threshold, see \link[MassSpecWavelet]{peakDetectionCWT}.}

\item{nCPU}{The amount of cpu's to be used for peak detection. If set to '-1' all available cores minus 1 will be used.}

\item{include_nearbyPeaks}{If set to TRUE small peaks in the tails of larger ones will be included in the peak data, see \link[MassSpecWavelet]{peakDetectionCWT}.}
}
\value{
The peaks detected with the wavelets.
}
\description{
This function converts phase corrected NMR spectra to peak data by using wavelet based peak detection (with the MassSpecWavelet package)
}
\examples{
subset <- GetWinedata.subset()
subset.spectra = as.matrix(subset$Spectra)
subset.ppm = as.numeric(subset$PPM)

test.peaks <- getWaveletPeaks(Y.spec=subset.spectra, 
                              X.ppm=subset.ppm ,
                              nCPU = 2) # nCPU set to 2 for the vignette build

}
\author{
Charlie Beirnaert, \email{charlie.beirnaert@uantwerpen.be}
}
