% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAS.R
\name{getBASSampleDriver}
\alias{getBASSampleDriver}
\title{Manage BAS sampling.}
\usage{
getBASSampleDriver(shapefile, bb, n, seeds, verbose = FALSE)
}
\arguments{
\item{shapefile}{sf shape file as a polygon to select sites from.}

\item{bb}{Bounding box which defines the area around the study area. A bounding box must be
supplied.}

\item{n}{Number of sites to select. If using stratification it is a named vector containing
sample sizes of each group.}

\item{seeds}{A vector of 2 seeds, u1 and u2. If not specified, the default is NULL and will
be defined randomly.}

\item{verbose}{Boolean if you want to see any output printed to screen. Helpful if taking a
long time. Default is FALSE i.e. no informational messages are displayed.}
}
\value{
A list containing two variables, \code{$sample} containing locations in the BAS sample,
in BAS order and \code{$seeds}, the u1 and u2 seeds used to generate the sample.
}
\description{
This function repeatedly calls function spbal::getBASSample to generate the BAS
sample. Once the requested number of points within the intersection of the shapefile and the
study area have been obtained, the sample and seeds are returned to the caller.
}
\author{
This function was written by Phil Davies based on origin code by Paul van Dam-Bates
from the BASMasterSample package.
}
\keyword{internal}
