% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRS.R
\name{SRS}
\alias{SRS}
\title{Simple random sampling.}
\usage{
SRS(seed = 511, total_rows = 0, sample_size = 0)
}
\arguments{
\item{seed}{The random seed to be used to draw the current sample.}

\item{total_rows}{The total number of rows in our input dataset.}

\item{sample_size}{The number of rows wanted in our random sample.}
}
\value{
A random sample.
}
\description{
This function invokes base::sample() to draw a random sample using
a user specified random seed.
}
\details{
This function was written by Phil Davies.
}
\examples{
# Create a random sample with a seed of 99 ----------------------------------
spbal::SRS(seed = 99, total_rows = 100, sample_size = 20)

# Create a random sample with a seed of 42 ----------------------------------
spbal::SRS(seed = 42, total_rows = 100, sample_size = 20)

# Create a random sample with a seed of 99 ----------------------------------
spbal::SRS(seed = 99, total_rows = 100, sample_size = 25)

}
