/*
	$Revision: 1.1 $ $Date: 2009/11/04 23:54:15 $

	Definitions of C structures 
	for spatial statistics function estimates.

	Usually the estimates are of the form f^(x) = a^(x)/b^(x);
	we store f^ and also a^ and b^ to cater for 
	applications with replicated data.

# /////////////////////////////////////////////
# AUTHOR: Adrian Baddeley, CWI, Amsterdam, 1991.
# 
# This software is distributed free
# under the conditions that
# 	(1) it shall not be incorporated
# 	in software that is subsequently sold
# 	(2) the authorship of the software shall
# 	be acknowledged in any publication that 
# 	uses results generated by the software
# 	(3) this notice shall remain in place
# 	in each file.
# //////////////////////////////////////////////

*/

typedef struct Ftable {		/* double precision function table */
	double	t0;
	double	t1;
	int	n;		/* number of entries */
	double 	*f;		
	double	*num;		/* 	f[i]  = num[i]/denom[i] 	*/
	double	*denom;
} Ftable;

typedef struct Itable {		/* integer count table e.g for histograms */
	double	t0;
	double	t1;
	int	n;

	int	*num;
	int	*denom;		/* usually p[i] = num[i]/denom[i] */
} Itable;

typedef struct H4table {	/* Four histograms, for censored data */
  double	t0;
  double	t1;
  int	n;

  int	*obs;  /* observed lifetimes: o_i = min(t_i, c_i) */
  int	*nco;  /* uncensored lifetimes: o_i for which t_i <= c_i */
  int	*cen;  /* censoring times: c_i */
  int	*ncc;  /* censor times of uncensored data: c_i for which t_i <= c_i */

  int   upperobs;  /* number of o_i that exceed t1 */
  int   uppercen;  /* number of c_i that exceed t1 */

} H4table;
