# 
# This file contains miscellaneous documentation for various objects. 
# 

#' @name simple_sews
#' 
#' @title \code{simple_sews} objects 
#' 
#' @description This help page describes the structure of \code{simple_sews_*} 
#'   objects, such as those defined by the classes \code{simple_sews_single},
#'   \code{simple_sews_list}
#' 
#' @details 
#' 
#' The \code{\link{spatialwarnings}} uses S3 objects (lists) internally to store 
#'   indicator values, along with the necessary data to plot and display
#'   results. It is not recommended to extract data directly from these objects,
#'   as they are subject to change with different releases of the package. The 
#'   preferred method is to use dedicated generic functions such as 
#'   \code{plot()} or \code{as.data.frame()} to display or export the results.
#'   Nonetheless, we document the structure of these objects here for reference. 
#' 
#' \code{simple_sews} objects are returned by all indicator functions that 
#'   return numeric values. This includes for example \code{\link{generic_sews}}, 
#'   \code{\link{flowlength_sews}}, \code{\link{compute_indicator}} but *not*
#'   \code{\link{patchdistr_sews}} or \code{\link{spectral_sews}}, which provide
#'   indicators that depend on non-numeric values (e.g. patch-size distribution
#'   type), or need to store more information than just a single numerical value
#'   (e.g. the spectrum of the input matrix). 
#' 
#' \code{simple_sews} objects come in multiple variants:
#'   \code{simple_sews_single} is the result of an indicator function applied to 
#'   a single matrix, and \code{simple_sews_test_single} is the result of 
#'   \code{\link{indictest}} applied to a \code{simple_sews_single} object. Both 
#'   these objects have list equivalents, \code{simple_sews_list} and 
#'   \code{simple_sews_test_list} which are simply a collection of their 
#'   'single' equivalent. These 'list' objects are used to store the results 
#'   of computations when working with multiple matrices. 
#' 
#' A \code{simple_sews_single} object is a list with the following components
#'   \itemize{
#'     \item{value: }{the indicator values. A vector of length one if there is 
#'       only one numeric value returned by the indicator function (e.g.
#'       \code{\link{flowlength_sews}}, or with a length above one otherwise}
#'     \item{orig_data: }{the original matrix on which the indicator was computed} 
#'     \item{fun.args: }{the argument used in the call to the indicator function 
#'       (the function that given a matrix, returns the spatial metrics of
#'       interest)}
#'     \item{taskname: }{a character string describing the current indicator(s) 
#'       being computed}
#'     \item{indicf: }{the indicator function, which given the matrix, returns the
#'       spatial metric(s) of interest}
#'   }
#' 
#'   \code{simple_sews_test_single} have all of the above components, plus 
#' the following: 
#' 
#' \itemize{ 
#'   \item{nulldistr: }{the null distribution of values, with nulln rows and 
#'     as many columns as the number of values returned by the indicator 
#'     function}
#'   \item{null_mean: }{the mean indicator values in the null distribution}
#'   \item{null_sd: }{the standard deviation of the null distribution}
#'   \item{null_qsup: }{the upper quantile of the null distribution, by default 
#'     the 95% upper quantile, but see \code{\link{indictest}} for a way to 
#'     adjust this}
#'   \item{null_qinf: }{the upper quantile of the null distribution, by default 
#'     the 05% upper quantile, but see \code{\link{indictest}} for a way to 
#'     adjust this}
#'   \item{z_score: }{the z_score of the observed value relative to the null 
#'     distribution, i.e. (value - null_mean) / null_sd}
#'   \item{pval: }{the p-value of the indicator, i.e. the proporation of values 
#'     of the null distribution that fall below the observed indicator value}
#'   \item{null_method: }{the method used to produce the null matrices. See 
#'     \code{\link{indictest}} for details}
#'   \item{nulln: }{the number of null matrices used}
#'   \item{get_nullmat: }{a function that can be called to obtain a randomized 
#'     matrix}
#'   \item{matrixn: }{the number of the matrix, can be above one if the
#'     computations have been run on a list of matrices, or non-existent if 
#'     only one matrix was used}
#' }
#' 
#' @seealso \code{\link{custom_indicator}} 
#'
#' @aliases simple_sews_object
#'
NULL

