% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_block_cv.R
\name{spatial_block_cv}
\alias{spatial_block_cv}
\title{Spatial block cross-validation}
\usage{
spatial_block_cv(
  data,
  method = c("random", "snake", "continuous"),
  v = 10,
  relevant_only = TRUE,
  radius = NULL,
  buffer = NULL,
  ...
)
}
\arguments{
\item{data}{An object of class \code{sf} or \code{sfc}.}

\item{method}{The method used to sample blocks for cross validation folds.
Currently supports \code{"random"}, which randomly assigns blocks to folds,
\code{"snake"}, which labels the first row of blocks from left to right,
then the next from right to left, and repeats from there,
and \code{"continuous"}, which labels each row from left
to right, moving from the bottom row up.}

\item{v}{The number of partitions of the data set.}

\item{relevant_only}{For systematic sampling, should only blocks containing
data be included in fold labeling?}

\item{radius}{Numeric: points within this distance of the initially-selected
test points will be assigned to the assessment set. If \code{NULL}, no radius is
applied.}

\item{buffer}{Numeric: points within this distance of any point in the
test set (after \code{radius} is applied) will be assigned to neither the analysis
or assessment set. If \code{NULL}, no buffer is applied.}

\item{...}{Arguments passed to \code{\link[sf:st_make_grid]{sf::st_make_grid()}}.}
}
\value{
A tibble with classes \code{spatial_block_cv},  \code{spatial_rset}, \code{rset},
\code{tbl_df}, \code{tbl}, and \code{data.frame}. The results include a column for the
data split objects and an identification variable \code{id}.
}
\description{
Block cross-validation splits the area of your data into a number of
grid cells, or "blocks", and then assigns all data into folds based on the
blocks their centroid falls into.
}
\details{
The grid blocks can be controlled by passing arguments to
\code{\link[sf:st_make_grid]{sf::st_make_grid()}} via \code{...}. Some particularly useful arguments include:
\itemize{
\item \code{cellsize}: Target cellsize, expressed as the "diameter" (shortest
straight-line distance between opposing sides; two times the apothem)
of each block, in map units.
\item \code{n}: The number of grid blocks in the x and y direction (columns, rows).
\item \code{square}: A logical value indicating whether to create square (\code{TRUE}) or
hexagonal (\code{FALSE}) cells.
}

If both \code{cellsize} and \code{n} are provided, then the number of blocks requested
by \code{n} of sizes specified by \code{cellsize} will be returned, likely not
lining up with the bounding box of \code{data}. If only \code{cellsize}
is provided, this function will return as many blocks of size
\code{cellsize} as fit inside the bounding box of \code{data}. If only \code{n} is provided,
then \code{cellsize} will be automatically adjusted to create the requested
number of cells.
}
\examples{

spatial_block_cv(boston_canopy, v = 3)

}
\references{
D. R. Roberts, V. Bahn, S. Ciuti, M. S. Boyce, J. Elith, G. Guillera-Arroita,
S. Hauenstein, J. J. Lahoz-Monfort, B. Schröder, W. Thuiller, D. I. Warton,
B. A. Wintle, F. Hartig, and C. F. Dormann. "Cross-validation strategies for
data with temporal, spatial, hierarchical, or phylogenetic structure," 2016,
Ecography 40(8), pp. 913-929, doi: 10.1111/ecog.02881.
}
