% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_moran.R
\name{plot_moran}
\alias{plot_moran}
\title{Plots a Moran's I test of model residuals}
\usage{
plot_moran(
  model,
  point.color = viridis::viridis(
    100,
    option = "F",
    direction = -1
   ),
  line.color = "gray30",
  option = 1,
  ncol = 1,
  verbose = TRUE
)
}
\arguments{
\item{model}{A model fitted with \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}, or a data frame generated by \code{\link[=moran]{moran()}}. Default: \code{NULL}}

\item{point.color}{Colors of the plotted points. Can be a single color name (e.g. "red4"), a character vector with hexadecimal codes (e.g. "#440154FF" "#21908CFF" "#FDE725FF"), or function generating a palette (e.g. \code{viridis::viridis(100)}). Default: \code{viridis::viridis(100, option = "F")}}

\item{line.color}{Character string, color of the line produced by \code{ggplot2::geom_smooth()}. Default: \code{"gray30"}}

\item{option}{Integer, type of plot. If \code{1} (default) a line plot with Moran's I and p-values across distance thresholds is returned. If \code{2}, scatterplots of residuals versus lagged residuals per distance threshold and their corresponding slopes are returned. In models fitted with \code{\link[=rf_repeat]{rf_repeat()}}, the residuals and lags of the residuals are computed from the median residuals across repetitions. Option \code{2} is disabled if \code{x} is a data frame generated by \code{\link[=moran]{moran()}}.}

\item{ncol}{Number of columns of the plot. Only relevant when \code{option = 2}. Argument \code{ncol} of \link[patchwork]{wrap_plots}.}

\item{verbose}{Logical, if \code{TRUE}, the resulting plot is printed, Default: \code{TRUE}}
}
\value{
A ggplot.
}
\description{
Plots the results of spatial autocorrelation tests for a variety of functions within the package. The x axis represents the Moran's I estimate, the y axis contains the values of the distance thresholds, the dot sizes represent the p-values of the Moran's I estimate, and the red dashed line represents the theoretical null value of the Moran's I estimate.
}
\examples{
if(interactive()){

 #loading example data
 data(plant_richness_df)
 data(distance.matrix)

 #fitting a random forest model
 rf.model <- rf(
   data = plant_richness_df,
   dependent.variable.name = "richness_species_vascular",
   predictor.variable.names = colnames(plant_richness_df)[5:21],
   distance.matrix = distance_matrix,
   distance.thresholds = c(0, 1000, 2000),
   n.cores = 1,
   verbose = FALSE
 )

 #Incremental/multiscale Moran's I
 plot_moran(rf.model)

 #Moran's scatterplot
 plot_moran(rf.model, option = 2)

}
}
\seealso{
\code{\link[=moran]{moran()}}, \code{\link[=moran_multithreshold]{moran_multithreshold()}}
}
