% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_importance.R
\name{plot_importance}
\alias{plot_importance}
\title{Plots the variable importance of a model}
\usage{
plot_importance(
  model,
  fill.color = viridis::viridis(
    100,
    option = "F",
    direction = -1,
    alpha = 1,
    end = 0.9
   ),
  line.color = "white",
  verbose = TRUE
)
}
\arguments{
\item{model}{A model fitted with \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}, or a data frame with variable importance scores (only for internal use within the package functions).}

\item{fill.color}{Character vector with hexadecimal codes (e.g. "#440154FF" "#21908CFF" "#FDE725FF"), or function generating a palette (e.g. \code{viridis::viridis(100)}). Default: \code{viridis::viridis(100, option = "F", direction = -1, alpha = 0.8, end = 0.9)}}

\item{line.color}{Character string, color of the line produced by \code{ggplot2::geom_smooth()}. Default: \code{"white"}}

\item{verbose}{Logical, if \code{TRUE}, the plot is printed. Default: \code{TRUE}}
}
\value{
A ggplot.
}
\description{
Plots variable importance scores of \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, and \code{\link[=rf_spatial]{rf_spatial()}} models. Distributions of importance scores produced with \code{\link[=rf_repeat]{rf_repeat()}} are plotted using \code{ggplot2::geom_violin}, which shows the median of the density estimate rather than the actual median of the data. However, the violin plots are ordered from top to bottom by the real median of the data to make small differences in median importance easier to spot. Ths function does not plot the result of \code{\link[=rf_importance]{rf_importance()}} yet, but you can find it under \code{model$importance$cv.per.variable.plot}.
}
\examples{
if(interactive()){

#loading example data
data(plant_richness_df)
data(distance_matrix)

#fitting a random forest model
rf.model <- rf(
 data = plant_richness_df,
 dependent.variable.name = "richness_species_vascular",
 predictor.variable.names = colnames(plant_richness_df)[5:21],
 distance.matrix = distance_matrix,
 distance.thresholds = 0,
 n.cores = 1,
 verbose = FALSE
)

#plotting variable importance scores
plot_importance(model = rf.model)

}
}
\seealso{
\code{\link[=print_importance]{print_importance()}}, \code{\link[=get_importance]{get_importance()}}
}
