% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster.entropy.R
\name{raster.entropy}
\alias{raster.entropy}
\title{Raster Entropy}
\usage{
raster.entropy(x, d = 5, categorical = FALSE, global = FALSE, ...)
}
\arguments{
\item{x}{A terra SpatRaster object (requires integer raster)}

\item{d}{Size of matrix (window)}

\item{categorical}{Is the data categorical or continuous (FALSE/TRUE)}

\item{global}{Should the model use a global or local n to calculate 
entropy (FALSE/TRUE)}

\item{...}{Optional arguments passed terra focal function}
}
\value{
terra SpatRaster class object
}
\description{
Calculates entropy on integer raster (i.e., 8 bit 0-255)

Entropy calculated as: H = -sum(Pi*ln(Pi)) where; Pi, Proportion of one value 
to total values Pi=n(p)/m and m, Number of unique values. Expected range: 
0 to log(m) H=0 if window contains the same value in all cells.
H increases with the number of different values in the window. The ellipsis
arguments can be used to write to disk using the filename argument. 

Maximum entropy is reached when all values are different, same as log(m)
  max.ent <- function(x) { log( length( unique(x) ) ) }
}
\examples{
library(terra)
  r <- rast(ncols=100, nrows=100)
    r[] <- round(runif(ncell(r), 1,8), digits=0)

rEnt <- raster.entropy(r, d=5, categorical = TRUE, global = TRUE)
  opar <- par(no.readonly=TRUE)
    par(mfcol=c(2,1))
      plot(r)
        plot(rEnt)
  par(opar)

}
\references{
Fuchs M., R. Hoffmann, F. Schwonke (2008) Change Detection with GRASS 
  GIS - Comparison of images taken by different sensor.
}
