% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parea.sample.R
\name{parea.sample}
\alias{parea.sample}
\title{Percent area sample}
\usage{
parea.sample(x, pct = 0.1, join = FALSE, sf = 4046.86, stype = "random", ...)
}
\arguments{
\item{x}{An sf POLYGON object}

\item{pct}{Percent of area sampled}

\item{join}{{FALSE/TRUE} Join polygon attributed to point sample}

\item{sf}{Scaling factor (default is meters to acres conversion factor)}

\item{stype}{Sampling type ('random', 'regular', 'nonaligned', 'hexagonal')}

\item{...}{Additional arguments passed to spsample}
}
\value{
An sf POINT object
}
\description{
Creates a point sample of polygons where n is based 
             on percent area
}
\note{
This function results in an adaptive sample based on the area of 
each polygon. The default scaling factor (sf) converts meters to
acres. You can set sf=1 to stay in the native projection units
}
\examples{
if(require(sf, quietly = TRUE)) {
  nc <- st_read(system.file("shape/nc.shp", package="sf"))
    nc <- suppressWarnings(st_cast(nc[c(10,100),], "POLYGON"))
  
  ( ars <- parea.sample(nc, pct=0.001, join = TRUE, stype='random') ) 
    plot(st_geometry(nc))
      plot(st_geometry(ars), pch=19, add=TRUE)  
}

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
