% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sa.trans.R
\name{sa.trans}
\alias{sa.trans}
\title{Trigonomic transformation of a slope and aspect interaction}
\usage{
sa.trans(slope, aspect, type = "cos", slp.units = "degrees",
  asp.units = "degrees")
}
\arguments{
\item{slope}{slope values in degrees, radians or percent}

\item{aspect}{aspect values in degrees or radians}

\item{type}{Type of transformation, options are: "cos", "sin",}

\item{slp.units}{Units of slope values, options are: "degrees", "radians" or "percent"}

\item{asp.units}{Units of aspect values, options are: "degrees" or "radians"}
}
\value{
A vector of the modeled value
}
\description{
The trigonomic Stage (1978) [slope * cos(aspect)] or [slope * sin(aspect)]
}
\note{
An a priori assumption of a maximum in the NW quadrant (45 azimuth)
and a minimum in the SW quadrant can be replaced by an empirically
determined location of the optimum without repeated caculations of
the regression fit. In addition it is argued that expressions for
the effects of aspect should always be considered as terms involving
an interaction with slope (Stage, 1976)

For slopes from 0% - 100%, The functions are linerized and
bounded from -1 to 1. Greater than 100% slopes are treated
out of the -1 to 1 range.

An alternative for slopes with values approaching infinity is
to take the square root of slope/100 to reduce the range of
values.By default this model sest all values greater than 100%
to 101% and flat areas (-1) to nodata.
}
\examples{
 sa.trans(slope = 48.146, aspect = 360.000)

 library(raster)
 data(elev)
 sa <- raster::terrain(elev, opt=c("slope", "aspect"), unit="degrees")
 scosa <- raster::overlay(sa[[1]], sa[[2]], fun = sa.trans)

}
\references{
Stage, A. R. 1976. An Expression of the Effects of Aspect, Slope, and Habitat Type on Tree Growth. Forest Science Vol 22, No 3, 457-460.
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
