% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concordance.R
\name{concordance}
\alias{concordance}
\title{Concordance test for binomial models}
\usage{
concordance(y, p)
}
\arguments{
\item{y}{vector of binomial response variable used in model}

\item{p}{estimated probabilities from fit binomial model}
}
\value{
A list class object with the following components: 

 concordance  percent of positives that are greater than probabilities of nulls

 isconcordance inverse of concordance representing null class

 tied number of tied probabilities

 pairs number of pairs compared

}
\description{
Performs a concordance/disconcordance (C-statistic) test on binomial models.  

}
\note{

The C-statistic has been show to be comparable to the area under an ROC.



Test of binomial regression for the hypothesis that probabilities of all positives [1], are greater than the probabilities of the nulls [0]. 
The concordance would be 100% for a perfect model where, disconcordance is the inverse of concordance, representing the null

}
\examples{
data(mtcars)
dat <- subset(mtcars, select=c(mpg, am, vs))
glm.reg <- glm(vs ~ mpg, data = dat, family = binomial)
concordance(dat$vs, predict(glm.reg, type = "response")) 

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>

}
\references{

Austin, P.C. & E.W. Steyerberg (2012) Interpreting the concordance statistic of a logistic regression model: relation to the variance and odds ratio of a continuous explanatory variable. BMC Medical Research Methodology, 12:82 
Harrell, F.E. (2001) Regression modelling strategies. Springer, New York, NY. 
Royston, P. & D.G. Altman (2010) Visualizing and assessing discrimination in the logistic regression model. Statistics in Medicine 29(24):2508-2520

}

