% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enkf.R
\name{enkf}
\alias{enkf}
\alias{enkf,ANY-method}
\alias{enkf,missing-method}
\alias{enkf-spatPomp}
\alias{enkf,spatPomp-method}
\title{Generalized Ensemble Kalman filter (EnKF)}
\usage{
\S4method{enkf}{spatPomp}(data, Np, ..., verbose = getOption("verbose", FALSE))
}
\arguments{
\item{data}{A \code{spatPomp} object.}

\item{Np}{The number of Monte Carlo particles used to approximate the filter distribution.}

\item{...}{If a \code{params} argument is specified, \code{abf} will estimate the likelihood at that parameter set instead of at \code{coef(object)}.}

\item{verbose}{logical; if \code{TRUE}, messages updating the user on progress will be printed to the console.}
}
\value{
An object of class \sQuote{enkfd_spatPomp} that contains the estimate of the log likelihood
(via the \code{loglik} attribute), algorithmic parameters used to run \code{enkf()}. Also included
are estimated filter means, prediction means and forecasts that are generated during an \code{enkf()} run.
}
\description{
A function to perform filtering using the ensemble Kalman filter of Evensen, G. (1994).
This function is generalized to allow for an measurement covariance matrix that varies over time.
This is useful if the measurement model varies with the state.
}
\examples{
# Complete examples are provided in the package tests
\dontrun{
# Create a simulation of a Brownian motion
b <- bm(U=2, N=5)

# Run EnKF
enkfd_bm <- enkf(b, Np = 20)

# Get a likelihood estimate
logLik(enkfd_bm)
}
}
\references{
\Evensen1994

\Evensen2009

\Anderson2001
}
\seealso{
Other particle filter methods: 
\code{\link{abfir}()},
\code{\link{abf}()},
\code{\link{bpfilter}()},
\code{\link{girf}()},
\code{\link{ibpf}()},
\code{\link{ienkf}()},
\code{\link{igirf}()},
\code{\link{iubf}()}
}
\concept{particle filter methods}
