% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.bssrest.r
\name{summary.bssrest}
\alias{summary.bssrest}
\title{Summarizing Blinded Sample Size Reestimation}
\usage{
\method{summary}{bssrest}(object, ...)
}
\arguments{
\item{object}{an object of class "\code{bssrest}".}

\item{...}{Arguments to be passed to or from other methods.}
}
\description{
\code{summary} method for class "\code{bssrest}".
}
\details{
\code{summary.bssrest} gives back blinded sample size estimates. Furthermore, inputs are displayed for double checking.
}
\examples{
#Calculate required sample size to find significant difference with
#80\% probability when testing the Nullhypothesis H_0: mu_T/mu_C >= 1
#assuming the true effect delta is 0.8 and rate, size and correlation
#parameter in the control group are 2, 1 and 0.5, respectively.

estimate<-n.nb.inar1(alpha=0.025, power=0.8, delta=0.8, muC=2, size=1, rho=0.5, tp=7, k=1)

#Simulate data
set.seed(8)
placebo<-rnbinom.inar1(n=50, size=1, mu=2, rho=0.5, tp=7)
treatment<-rnbinom.inar1(n=50, size=1, mu=1.6, rho=0.5, tp=7)

#Blinded sample size reestimation
estimate<-bssr.nb.inar1(alpha=0.025, power=0.8, delta=0.8, x=rbind(placebo, treatment),
  n=c(50,50), k=1)
summary(estimate)
}
\seealso{
\code{\link{n.nb.inar1}} for initial sample size estimates within the NB-INAR(1) model.
}
