% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r.1subgroup.r
\name{r.1subgroup}
\alias{r.1subgroup}
\title{Generate dataset of normal distributed observations in a one subgroup design}
\source{
\code{r.1subgroup} uses code contributed by Marius Placzek.
}
\usage{
r.1subgroup(n, delta, sigma, tau, fix.tau = c("YES", "NO"), k)
}
\arguments{
\item{n}{number of observations. If length(n) > 1, the length is taken to be the number required.}

\item{delta}{vector of treatment effects in the treatment group, c(outside subgroup, within subgroup).}

\item{sigma}{vector of standard deviations, c(outside subgroup, inside subgroup).}

\item{tau}{subgroup prevalence.}

\item{fix.tau}{subgroup prevalence fix or simulated according to tau, see 'Details'.}

\item{k}{sample size allocation factor between groups: see 'Details'.}
}
\value{
\code{r.1subgroup} returns a data matrix of dimension \code{n} x \code{3}. The first column \code{TrPl} defines whether
the observation belongs to the treatment group (\code{TrPl=0}) or to the placebo group (\code{TrPl=1}). Second column
contains the grouping variable \code{FS}. For \code{FS=1} the observation stems from the subgroup, for \code{FS=0} from
the full population without the subgroup. In the last column \code{value} the observation can be found.
between time points.
}
\description{
\code{r.1subgroup} generates data for a design with one subgroup within a full population. Each observation is normal distributed with mean 0 in the placebo group and a potential effect in the treatment group. Whether the effect is solely in the subgroup or additionally a certain amount outside of the subgroup can be specified as well as potentially different variances within the subgroup and outside of the subgroup.
}
\details{
For \code{delta}\eqn{=(\Delta_F\S, \Delta_S)'} and \code{sigma}\eqn{=(\sigma_F\S, \sigma_S)'}
this function \code{r.1subgroup} generates data as follows:

Placebo group outside of subgroup \eqn{~N(0,\sigma^2_F\S)},
Placebo group within subgroup \eqn{~N(0,\sigma^2_S)},
Treatment group outside of subgroup \eqn{~N(\Delta_F\S,\sigma^2_F\S)},
Treatment group within subgroup \eqn{~N(\Delta_S,\sigma^2_S)}.

If \code{fix.tau=YES} the subgroup size is generated according to the prevalence \code{tau}, i.e. \eqn{n_S=\tau*n}.
If \code{fix.tau=YES}, then each new generated observations probability to belong to the subgroup is \eqn{Ber(\code{tau})}
distributed and therefore only \eqn{E(n_s)=\tau*n} holds.

The argument \code{k} is the
sample size allocation factor, i.e. let \eqn{n_C} and \eqn{n_T} denote the sample sizes of of the control and
treatment group, respectively, then \eqn{k = n_T/n_C}.
}
\examples{

set.seed(142)
random<-r.1subgroup(n=50, delta=c(0,1), sigma=c(1,1), tau=0.4, fix.tau="YES", k=2)
random 
}

