% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustness_plotting.R
\name{oat_graphATestsForSampleSize}
\alias{oat_graphATestsForSampleSize}
\title{Takes each parameter in turn and creates a plot showing A-Test score against parameter value.}
\usage{
oat_graphATestsForSampleSize(FILEPATH, PARAMETERS, MEASURES, ATESTSIGLEVEL,
  ATESTRESULTFILENAME, BASELINE, PMIN = NULL, PMAX = NULL, PINC = NULL,
  PARAMVALS = NULL, TIMEPOINTS = NULL, TIMEPOINTSCALE = NULL)
}
\arguments{
\item{FILEPATH}{Directory where either the simulation runs or single CSV file result can be found}

\item{PARAMETERS}{Array containing the names of the parameters for which local analyses are being conducted}

\item{MEASURES}{Array containing the names of the output measures which are used to analyse the simulation}

\item{ATESTSIGLEVEL}{The A-Test determines if there is a large difference between two sets if the result is greater than 0.21 either side of the 0.5 line. Should this not be suitable, this can be changed here}

\item{ATESTRESULTFILENAME}{File name of the ATests result summary file that will be created For one timepoint, this could be ATests.csv. For additional timepoints, the time is added to the file name}

\item{BASELINE}{Array containing the values assigned to each of these parameters in the calibrated baseline}

\item{PMIN}{Array containing the minimum value that should be used for each parameter.  Sets a lower bound on sampling space}

\item{PMAX}{Array containing the maximum value that should be used for each parameter.  Sets an upper bound on sampling space}

\item{PINC}{Array containing the minimum value that should be used for each parameter.  Sets a lower bound on sampling space}

\item{PARAMVALS}{Array containing a list of strings for each parameter, each string containing comma separated values that should be assigned to that parameter. Thus sampling can be performed for specific values for each parameter, rather than a uniform incremented value. This replaces the PMIN, PMAX, and PINC where this method is used}

\item{TIMEPOINTS}{Implemented so this method can be used when analysing multiple simulation timepoints. If only analysing one timepoint, this should be set to NULL. If not, this should be an array of timepoints, e.g. c(12,36,48,60)}

\item{TIMEPOINTSCALE}{Implemented so this method can be used when analysing multiple simulation timepoints. Sets the scale of the timepoints being analysed, e.g. "Hours"}
}
\description{
This makes it easy to determine how the effect that changing the parameter
has had on simulation results. Graph for each parameter is output as a PDF
}
