% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcSimulations.R
\name{mcSimulations}
\alias{mcSimulations}
\title{Monte Carlo simulations}
\usage{
mcSimulations(N, nobs = 250, nMC = 100, rho = 0.5, sparsity = 0.05,
  penalty = "ENET", covariance = "toeplitz", method = "normal", ...)
}
\arguments{
\item{N}{dimension of the multivariate time series.}

\item{nobs}{number of observations to be generated.}

\item{nMC}{number of Monte Carlo simulations.}

\item{rho}{base value for the covariance.}

\item{sparsity}{density of non zero entries of the VAR matrices.}

\item{penalty}{penalty function to use for LS estimation. Possible values are \code{"ENET"}, 
\code{"SCAD"} or \code{"MCP"}.}

\item{covariance}{type of covariance matrix to be used in the generation of the sparse VAR model.}

\item{method}{which type of distribution to use in the generation of the entries of the matrices.}

\item{...}{(TODO: complete)}
}
\value{
a \code{nMc}x5 matrix with the results of the Monte Carlo estimation
}
\description{
This function generates monte carlo simultaions of sparse VAR and 
its estimation (at the moment only for VAR(1) processes).
}

