% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_spark.R
\name{copy_to}
\alias{copy_to}
\alias{copy_to.spark_connection}
\title{Copy a local R data frame to Spark}
\usage{
\method{copy_to}{spark_connection}(dest, df, name = deparse(substitute(df)),
  memory = TRUE, repartition = 0, overwrite = FALSE, ...)
}
\arguments{
\item{dest}{A Spark connection}

\item{df}{Local data frame to copy}

\item{name}{Name of the destination table}

\item{memory}{Cache table into memory}

\item{repartition}{Partitions used to distribute table or 0 (default) to avoid partitioning}

\item{overwrite}{When TRUE, overwrites table with existing name}

\item{...}{Unused}
}
\value{
dplyr compatible reference to table
}
\description{
Copy a local R data frame to Spark
}
\seealso{
Other dplyr: \code{\link{tbl_cache}},
  \code{\link{tbl_uncache}}
}

