% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest.R
\name{sdf_nest}
\alias{sdf_nest}
\title{Nest data in a Spark Dataframe}
\usage{
sdf_nest(x, ..., .key = "data")
}
\arguments{
\item{x}{A Spark dataframe.}

\item{...}{Columns to nest.}

\item{.key}{Character. A name for the new column containing nested fields}
}
\description{
This function is like \code{tidyr::nest}. Calling this function will not
aggregate over other columns. Rather the output has the same number of
rows/records as the input. See examples of how to achieve row reduction
by aggregating elements using \code{collect_list}, which is a Spark SQL function
}
\examples{
\dontrun{
# produces a dataframe with an array of characteristics nested under
# each unique species identifier
iris2 <- copy_to(sc, iris, name="iris")
iris2 \%>\%
  sdf_nest(Sepal_Length, Sepal_Width, Petal_Length, Petal_Width, .key="data") \%>\%
  group_by(Species) \%>\%
  summarize(data=collect_list(data))
}

}
